<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\AdministradoresController;
use App\Http\Controllers\InstitucionesRepsController;
use App\Http\Controllers\InstitucionesController;
use App\Http\Controllers\SedesRepsController;
use App\Http\Controllers\SedesController;
use App\Http\Controllers\CostosController;
use App\Http\Controllers\ContratoController;
use App\Http\Controllers\AvanceModulosController;
use App\Http\Controllers\UsoModulosController;
use App\Http\Controllers\RolesController;
use App\Http\Controllers\UsuariosController;
use App\Http\Controllers\DepartamentosController;
use App\Http\Controllers\MunicipiosController;
use App\Http\Controllers\ElementosController;
use App\Http\Controllers\NaturalezaCuentaController;
use App\Http\Controllers\TipoRecursoController;
use App\Http\Controllers\CaracterRecursoController;
use App\Http\Controllers\RegimenController;
use App\Http\Controllers\CorreoController;
use App\Http\Controllers\ParametrosController;
use App\Http\Controllers\CentrosUtilidadController;
use App\Http\Controllers\SubcentrosUtilidadController;
use App\Http\Controllers\CentrosCostoController;
use App\Http\Controllers\DetalleElementosController;
use App\Http\Controllers\CuentasContablesController;
use App\Http\Controllers\ActividadesController;
use App\Http\Controllers\ActividadesCentroCostoController;
use App\Http\Controllers\PaquetesActividadesController;
use App\Http\Controllers\ProgramasController;
use App\Http\Controllers\GestionProgramasController;
use App\Http\Controllers\BasesDistribucionController;
use App\Http\Controllers\DistribucionCostosController;
use App\Http\Controllers\GrupoSuministrosController;
use App\Http\Controllers\RelCucGrSuministrosController;
use App\Http\Controllers\SuministrosController;
use App\Http\Controllers\SuministrosCentroCostoController;
use App\Http\Controllers\ManoObraController;
use App\Http\Controllers\ManoObraCentroCostoController;
use App\Http\Controllers\RecDirectosActividadController;
use App\Http\Controllers\ContratosEpsController;
use App\Http\Controllers\InformacionFinancieraController;
use App\Http\Controllers\InformacionBasesDistribucionController;
use App\Http\Controllers\InformacionProduccionController;
use App\Http\Controllers\RecursosCentroCostoController;
use App\Http\Controllers\CostoPrimarioController;
use App\Http\Controllers\CostoDistribuidoController;
use App\Http\Controllers\CostoTotalController;
use App\Http\Controllers\ManoObraTercerosController;
use App\Http\Controllers\InformacionManoObraController;
use App\Http\Controllers\ValorMinutoController;
use App\Http\Controllers\TasaRecursosIndirectosController;
use App\Http\Controllers\DetalleSuministrosController;
use App\Http\Controllers\DetallePobProgramaController;
use App\Http\Controllers\CostoUnitarioController;
use App\Http\Controllers\CostoUnitarioAjustadoController;
use App\Http\Controllers\CostoPaquetesController;
use App\Http\Controllers\MonitorContratosController;
use App\Http\Controllers\CostosIngresosController;
use App\Http\Controllers\ComposicionCostoController;
use App\Http\Controllers\DistribucionCostoController;
use App\Http\Controllers\CostoUnitarioPromedioController;
use App\Http\Controllers\AnalisisCostoVolumenController;
use App\Http\Controllers\DetalleCostoPrimarioController;
use App\Http\Controllers\LogActividadesController;

/*Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api'], 'prefix' => 'temp'], function() {
    Route::post('/encriptarContrasenas', [UsuariosController::class, 'encriptarContrasenas']);
});*/

// DUENO DE LA HERRAMIENTA
Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api', 'checkToken'], 'prefix' => 'admin'], function() {
    Route::post('/usuarios/validarUsuario', [AdministradoresController::class, 'validarUsuario']);
    Route::post('usuarios/validarTokenUsuario', [AdministradoresController::class, 'validarTokenUsuario']);

    Route::post('/auxiliares/crearInstitucionesReps', [InstitucionesRepsController::class, 'crearInstitucion']);
    Route::post('/auxiliares/actualizarInstitucionesReps', [InstitucionesRepsController::class, 'actualizarInstitucionReps']);
    Route::post('/auxiliares/crearSedesReps', [SedesRepsController::class, 'crearSedesReps']);
    Route::post('/auxiliares/actualizarSedesReps', [SedesRepsController::class, 'actualizarSedesReps']);

    Route::post('/crearContrato', [ContratoController::class, 'crearContrato']);
    Route::post('/verificarIdContrato', [ContratoController::class, 'verificarExistenciaId']);
    Route::post('/getContrato', [ContratoController::class, 'getContrato']);
    Route::post('/getListaContratos', [ContratoController::class, 'getListaContratos']);
    Route::post('/getListaContratosPorFecha', [ContratoController::class, 'getListaContratosPorFecha']);
    Route::post('/getInstContrato',[InstitucionesRepsController::class, 'getInstContrato']);

    Route::post('/usuarios/getUsuarioResponsableEmpresa', [UsuariosController::class, 'getUsuarioResponsableEmpresa']);
    Route::post('/usuarios/getUsuarioResponsableEmpresaSinIntitucion', [UsuariosController::class, 'getUsuarioResponsableEmpresaSinInstitucion']);

    Route::post('/auxiliares/getDepartamentos', [DepartamentosController::class, 'getDepartamentos']);
    Route::post('/auxiliares/getMunicipios', [MunicipiosController::class, 'getMunicipios']);
    Route::post('/auxiliares/getInstitucionesReps', [InstitucionesRepsController::class, 'getInstituciones']);
    Route::post('/getInstPorCodigo', [InstitucionesRepsController::class, 'getInstPorCodigo']);
    Route::post('/auxiliares/actualizarInstitucionesReps', [InstitucionesRepsController::class, 'actualizarInstitucionReps']);
    Route::post('/auxiliares/getSedesReps', [SedesRepsController::class, 'getSedePorCodigo']);
    Route::post('/auxiliares/actualizarSedesReps', [SedesRepsController::class, 'actualizarSedesReps']);
    Route::post('/auxiliares/setInstContrato', [InstitucionesRepsController::class, 'setInstContrato']);

    Route::post('/auxiliares/infoUsuario', [CorreoController::class, 'enviarInformacionUsuario']);
    Route::post('/auxiliares/infoUsuario2', [CorreoController::class, 'enviarInformacionUsuario2']);
});

// AUXILIARES
Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api', 'checkToken'], 'prefix' => 'auxiliares'], function() {
    Route::post('/setSedesContrato', [InstitucionesRepsController::class, 'setSedesContrato']);
    Route::post('/getSedesContrato', [SedesController::class, 'getSedesContrato']);
    Route::post('/crearSedeContrato', [SedesController::class, 'crearSedeContrato']);
    Route::post('/actualizarSedeContrato', [SedesController::class, 'actualizarSedeContrato']);

    Route::post('/getVersionAplicativo', [CostosController::class, 'getVersionAplicativo']);

    Route::post('/getContrato', [ContratoController::class, 'getContrato']);

    Route::post('/solicitarAccesoModulo', [UsoModulosController::class, 'solicitarAccesoModulo']);
    Route::post('/verificarAccesoModulo', [UsoModulosController::class, 'verificarAccesoModulo']);
    Route::post('/actualizarUltimaAccionModulo', [UsoModulosController::class, 'actualizarUltimaAccionModulo']);
    Route::post('/liberarModulo', [UsoModulosController::class, 'liberarModulo']);
    Route::post('/reestablecerActividadUsuario', [UsoModulosController::class, 'reestablecerActividadUsuario']);

    Route::post('/revisarUsuario', [UsuariosController::class, 'verificarExistenciaCuenta']);

    Route::post('/getElementos', [ElementosController::class, 'getElementos']);
    Route::post('/getNaturalezaCuenta', [NaturalezaCuentaController::class, 'getNaturalezaCuenta']);
    Route::post('/getTipoRecurso', [TipoRecursoController::class, 'getTipoRecurso']);
    Route::post('/getCaracterRecurso', [CaracterRecursoController::class, 'getCaracterRecurso']);
    Route::post('/getRegimenes', [RegimenController::class, 'getRegimenes']);

    Route::post('/crearLog', [LogActividadesController::class, 'crearLog']);
    Route::post('/getLogDetallado', [LogActividadesController::class, 'getDetalleActividades']);
    Route::post('/getLogAgrupado', [LogActividadesController::class, 'getLogAgrupado']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api', 'checkToken'], 'prefix' => 'aux'], function() {
    Route::post('/actualizarContrato',[ContratoController::class, 'actualizarContrato']);
    Route::post('/crearAvanceModulo', [AvanceModulosController::class, 'crearAvanceModulos']);
    Route::post('/notificarAvance', [AvanceModulosController::class, 'notificarAvance']);
    Route::post('/cancelarAvance', [AvanceModulosController::class, 'cancelarAvance']);
    Route::post('/getAvanceModulos', [AvanceModulosController::class, 'getAvanceModulos']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api', 'checkToken'], 'prefix' => 'usuarios'], function() {
    Route::post('/getRolResponsableEmpresa', [RolesController::class, 'getRolResponsableEmpresa']);
    Route::post('/getRolUsuarioEmpresa', [RolesController::class, 'getRolUsuarioEmpresa']);
    Route::post('/getRolUsuarioReportes', [RolesController::class, 'getRolUsuarioReportes']);
    Route::post('/getRolesRespEmpresa', [RolesController::class, 'getRolesResponsableEmpresa']);

    Route::post('/crearUsuario', [UsuariosController::class, 'crearUsuario']);
    Route::post('/actualizarUsuario', [UsuariosController::class, 'actualizarUsuario']);
    Route::post('/getUsuariosContratoNoResponsable', [UsuariosController::class, 'getUsuariosPorContratoNoResponsable']);

    Route::post('/validarUsuario', [UsuariosController::class, 'validarUsuario']);
    Route::post('/validarTokenUsuario', [UsuariosController::class, 'validarTokenUsuario']);

    Route::post('/getUsuarioBase', [UsuariosController::class, 'getUsuarioBase']);
    Route::post('/actualizarInfoBasicaUsuario', [UsuariosController::class, 'actualizarInfoBasicaUsuario']);
    Route::post('/recuperarContrasena', [UsuariosController::class, 'enviarContrasena']);

    Route::post('/aceptarPoliticaDatos', [UsuariosController::class, 'aceptarPoliticaProteccionDatos']);
    Route::post('/aceptarNuevasFuncionalidades', [UsuariosController::class, 'aceptarNuevasFuncionalidades']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api', 'checkToken'], 'prefix' => 'parametros'], function() {
    Route::post('/crearParametro', [ParametrosController::class, 'crearParametro']);
    Route::post('/actualizarParametro', [ParametrosController::class, 'actualizarParametro']);
    Route::post('/getParametro', [ParametrosController::class, 'getParametro']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api', 'checkToken'], 'prefix' => 'miempresa'], function() {
    Route::post('/getLogoInstitucion', [ContratoController::class, 'getLogoInstitucion']);
    Route::post('/actualizarLogoInstitucion', [ContratoController::class, 'actualizarLogoInstitucion']);

    Route::post('/crearCentroUtilidad', [CentrosUtilidadController::class, 'crearCentroUtilidad']);
    Route::post('/actualizarCentroUtilidad', [CentrosUtilidadController::class, 'actualizarCentroUtilidad']);
    Route::post('/borrarCentroUtilidad', [CentrosUtilidadController::class, 'borrarCentroUtilidad']);
    Route::post('/getCentrosUtilidad', [CentrosUtilidadController::class, 'getCentrosUtilidad']);

    Route::post('/crearSubcentroUtilidad', [SubcentrosUtilidadController::class, 'crearSubcentroUtilidad']);
    Route::post('/actualizarSubcentroUtilidad', [SubcentrosUtilidadController::class, 'actualizarSubcentroUtilidad']);
    Route::post('/borrarSubcentroUtilidad', [SubcentrosUtilidadController::class, 'borrarSubcentroUtilidad']);
    Route::post('/getSubcentrosUtilidad', [SubcentrosUtilidadController::class, 'getSubcentrosUtilidad']);
    Route::post('/getSubcentrosUtilidadPorCodigo', [SubcentrosUtilidadController::class, 'getSubcentroUtilidadPorCodigo']);
    Route::post('/getSubcentrosUtilidadPorCentroUtilidad', [SubcentrosUtilidadController::class, 'getSubcentroUtilidadPorCentroUtilidad']);

    Route::post('/crearCentroCosto', [CentrosCostoController::class, 'crearCentroCosto']);
    Route::post('/actualizarCentroCosto', [CentrosCostoController::class, 'actualizarCentroCosto']);
    Route::post('/borrarCentroCosto', [CentrosCostoController::class, 'borrarCentroCosto']);
    Route::post('/getCentrosCosto', [CentrosCostoController::class, 'getCentrosCosto']);
    Route::post('/getCentrosCostoCsv', [CentrosCostoController::class, 'getCentrosCostoCsv']);
    Route::post('/getCentrosCostoPorCodigo', [CentrosCostoController::class, 'getCentrosCostoPorCodigo']);
    Route::post('/getCentrosCostoPorCodigoHomologado', [CentrosCostoController::class, 'getCentrosCostoPorCodigoHomologado']);
    Route::post('/getCentrosCostoPorSubcentroUtilidad', [CentrosCostoController::class, 'getCentrosCostoPorSubcentroUtilidad']);
    Route::post('/getCentrosCostoPorSede', [CentrosCostoController::class, 'getCentrosCostoPorSede']);
    Route::post('/getCentrosCostoMultipleSede', [CentrosCostoController::class, 'getCentrosCostosMultipleSede']);
    Route::post('/validarEstructuraEmpresa', [CentrosCostoController::class, 'validarEstructuraEmpresa']);
    Route::post('/importarEstructuraEmpresa', [CentrosCostoController::class, 'importarEstructura']);

    Route::post('/crearDetalleElemento', [DetalleElementosController::class, 'crearDetalleElemento']);
    Route::post('/actualizarDetalleElemento', [DetalleElementosController::class, 'actualizarDetalleElemento']);
    Route::post('/borrarDetalleElemento', [DetalleElementosController::class, 'borrarDetalleElemento']);
    Route::post('/getDetalleElementos', [DetalleElementosController::class, 'getDetalleElementos']);
    Route::post('/getDetalleElementosCsv', [DetalleElementosController::class, 'getDetalleElementosCsv']);
    Route::post('/getDetalleElementosPorElemento', [DetalleElementosController::class, 'getDetalleElementosPorElemento']);

    Route::post('/crearCuentaContable', [CuentasContablesController::class, 'crearCuentaContable']);
    Route::post('/actualizarCuentaContable', [CuentasContablesController::class, 'actualizarCuentaContable']);
    Route::post('/actualizacionMasivaCuentasContables', [CuentasContablesController::class, 'actualizacionMasivaCuentasContables']);
    Route::post('/borrarCuentaContable', [CuentasContablesController::class, 'borrarCuentaContable']);
    Route::post('/getCuentasContables', [CuentasContablesController::class, 'getCuentasContables']);
    Route::post('/getCuentaContableEspecifica', [CuentasContablesController::class, 'getCuentaContableEspecifica']);
    Route::post('/importarCuentasContables', [CuentasContablesController::class, 'importarCuentasContables']);

    Route::post('/crearActividad', [ActividadesController::class, 'crearActividad']);
    Route::post('/actualizarActividad', [ActividadesController::class, 'actualizarActividad']);
    Route::post('/borrarActividad', [ActividadesController::class, 'borrarActividad']);
    Route::post('/getActividades', [ActividadesController::class, 'getActividades']);
    Route::post('/getActividadesCsv', [ActividadesController::class, 'getActividadesCsv']);
    Route::post('/getActividadEspecifica', [ActividadesController::class, 'getActividadEspecifica']);
    Route::post('/getPaquetes', [ActividadesController::class, 'getPaquetes']);
    Route::post('/getConteoPaquetes', [ActividadesController::class, 'getConteoPaquetes']);

    Route::post('/crearActividadesCentroCosto', [ActividadesCentroCostoController::class, 'crearActividadesCentroCosto']);
    Route::post('/actualizarActividadesCentroCosto', [ActividadesCentroCostoController::class, 'actualizarActividadesCentroCosto']);
    Route::post('/borrarActividadCentroCosto', [ActividadesCentroCostoController::class, 'borrarActividadCentroCosto']);
    Route::post('/getActividadesCentroCosto', [ActividadesCentroCostoController::class, 'getActividadesCentroCosto']);
    Route::post('/getActividadesCentroCostoSinPaquetes', [ActividadesCentroCostoController::class, 'getActividadesCentroCostoSinPaquetes']);
    Route::post('/getActividadesCentroCostoCompletas', [ActividadesCentroCostoController::class, 'getActividadesCentroCostoCompletas']);
    Route::post('/importarActividadesCentroCosto', [ActividadesCentroCostoController::class, 'importarActividadesCentroCosto']);

    Route::post('/getPaquetesAsignados', [PaquetesActividadesController::class, 'getPaquetes']);
    Route::post('/getActividadesPaquete', [PaquetesActividadesController::class, 'getActividadesPaquete']);
    Route::post('/crearActividadesPaquete', [PaquetesActividadesController::class, 'crearActividadesPaquete']);
    Route::post('/actualizarActividadesPaquete', [PaquetesActividadesController::class, 'actualizarActividadesPaquete']);
    Route::post('/borrarActividadesPaquete', [PaquetesActividadesController::class, 'borrarActividadesPaquete']);

    Route::post('/obtenerConteoProgramas', [ProgramasController::class, 'getConteoProgramas']);
    Route::post('/obtenerProgramas', [ProgramasController::class, 'getProgramas']);
    Route::post('/obtenerSedesPrograma', [ProgramasController::class, 'getSedesPrograma']);
    Route::post('/obtenerSedesProgramasCompleto', [ProgramasController::class, 'getSedesProgramasCompleto']);
    Route::post('/obtenerEstadiosPrograma', [ProgramasController::class, 'getEstadiosPrograma']);
    Route::post('/buscarCodigoPrograma', [ProgramasController::class, 'buscarCodigoPrograma']);
    Route::post('/obtenerProgramasEstadios', [ProgramasController::class, 'getProgramasEstadios']);
    Route::post('/crearPrograma', [ProgramasController::class, 'crearPograma']);
    Route::post('/actualizarPrograma', [ProgramasController::class, 'actualizarPrograma']);
    Route::post('/importarProgramas', [ProgramasController::class, 'importarProgramas']);

    Route::post('/obtenerAvanceProgramas', [GestionProgramasController::class, 'obtenerAvanceProgramas']);
    Route::post('/obtenerAsignacionActividades', [GestionProgramasController::class, 'obtenerAsignacionActividades']);
    Route::post('/obtenerAsignacionSuministros', [GestionProgramasController::class, 'obtenerAsignacionSuministros']);
    Route::post('/obtenerAsignacionPaquetes', [GestionProgramasController::class, 'obtenerAsignacionPaquetes']);
    Route::post('/crearAsignacionProgramas', [GestionProgramasController::class, 'crearAsignacionProgramas']);
    Route::post('/actualizarAsignacionProgramas', [GestionProgramasController::class, 'actualizarAsignacionProgramas']);

    Route::post('/crearBaseDistribucion', [BasesDistribucionController::class, 'crearBaseDistribucion']);
    Route::post('/actualizarBaseDistribucion', [BasesDistribucionController::class, 'actualizarBaseDistribucion']);
    Route::post('/borrarBaseDistribucion', [BasesDistribucionController::class, 'borrarBaseDistribucion']);
    Route::post('/verificarCodigoBaseDistribucion', [BasesDistribucionController::class, 'verificarCodigoBase']);
    Route::post('/getBasesDistribucion', [BasesDistribucionController::class, 'getBasesDistribucion']);
    Route::post('/getBasesDistribucionDistCostos', [BasesDistribucionController::class, 'getBasesDistribucionDistCostos']);
    Route::post('/getBasesDistribucionSinCostoPrimario', [BasesDistribucionController::class, 'getBasesDistribucionSinCostoPrimario']);
    Route::post('/getBasesDistribucionUsuario', [BasesDistribucionController::class, 'getBasesDistribucionUsuario']);
    Route::post('/getBasesDistribucionCompletas', [BasesDistribucionController::class, 'getBasesDistribucionCompletas']);
    Route::post('/importarBasesDistribucion', [BasesDistribucionController::class, 'importarBasesDistribucion']);

    Route::post('/crearDistribucionCostos', [DistribucionCostosController::class, 'crearDistribucionCostos']);
    Route::post('/actualizarDistribucionCostos', [DistribucionCostosController::class, 'actualizarDistribucionCostos']);
    Route::post('/getDistribucionCostosCentros', [DistribucionCostosController::class, 'getDistribucionCostosCentros']);
    Route::post('/getDistribucionCostosCentrosCompleto', [DistribucionCostosController::class, 'getDistribucionCostosCentrosCompleto']);
    Route::post('/getDistribucionCostosBases', [DistribucionCostosController::class, 'getDistribucionCostosBases']);
    Route::post('/getDistribucionCostosBasesCompleto', [DistribucionCostosController::class, 'getDistribucionCostosBasesCompleto']);
    Route::post('/importarInformacionDistribucion', [DistribucionCostosController::class, 'importarInformacionDistribucion']);

    Route::post('/crearGrupoSuministros', [GrupoSuministrosController::class, 'crearGrupoSuministros']);
    Route::post('/actualizarGrupoSuministros', [GrupoSuministrosController::class, 'actualizarGrupoSuministros']);
    Route::post('/borrarGrupoSuministros', [GrupoSuministrosController::class, 'borrarGrupoSuministros']);
    Route::post('/getGrupoSuministros', [GrupoSuministrosController::class, 'getGrupoSuministros']);
    Route::post('/getGrupoSuministrosCsv', [GrupoSuministrosController::class, 'getGrupoSuministrosCsv']);
    Route::post('/getGrupoSuministrosEspecifico', [GrupoSuministrosController::class, 'getGrupoSuministrosEspecifico']);

    Route::post('/crearRelCucGrSuministros', [RelCucGrSuministrosController::class, 'crearRelCucGrSuministros']);
    Route::post('/actualizarRelCucGrSuministros', [RelCucGrSuministrosController::class, 'actualizarRelCucGrSuministros']);
    Route::post('/getRelCucGrSuministros', [RelCucGrSuministrosController::class, 'getRelCucGrSuministros']);
    Route::post('/getRelCucGrSuministrosCompleto', [RelCucGrSuministrosController::class, 'getRelCucGrSuministrosCompleto']);

    Route::post('/crearSuministro', [SuministrosController::class, 'crearSuministro']);
    Route::post('/actualizarSuministro', [SuministrosController::class, 'actualizarSuministro']);
    Route::post('/borrarSuministro', [SuministrosController::class, 'borrarSuministro']);
    Route::post('/getSuministros', [SuministrosController::class, 'getSuministros']);
    Route::post('/getSuministrosCsv', [SuministrosController::class, 'getSuministrosCsv']);
    Route::post('/getSuministroEspecifico', [SuministrosController::class, 'getSuministroEspecifico']);
    Route::post('/getSuministrosPorGrupo', [SuministrosController::class, 'getSuministrosPorGrupo']);

    Route::post('/crearSuministroCentroCosto', [SuministrosCentroCostoController::class, 'crearSuministroCentroCosto']);
    Route::post('/actualizarSuministroCentroCosto', [SuministrosCentroCostoController::class, 'actualizarSuministroCentroCosto']);
    Route::post('/borrarSuministroCentroCosto', [SuministrosCentroCostoController::class, 'borrarSuministroCentroCosto']);
    Route::post('/getSuministrosCentroCosto', [SuministrosCentroCostoController::class, 'getSuministrosCentroCosto']);
    Route::post('/getSuministroCentroCostoEspecifico', [SuministrosCentroCostoController::class, 'getSuministroCentroCostoEspecifico']);

    Route::post('/crearManoObra', [ManoObraController::class, 'crearManoObra']);
    Route::post('/actualizarManoObra', [ManoObraController::class, 'actualizarManoObra']);
    Route::post('/borrarManoObra', [ManoObraController::class, 'borrarManoObra']);
    Route::post('/verificarCodigoCargo', [ManoObraController::class, 'verificarCodigoCargo']);
    Route::post('/getManoObra', [ManoObraController::class, 'getManoObra']);
    Route::post('/importarCargos', [ManoObraController::class, 'importarCargos']);

    Route::post('/crearManoObraCentroCosto', [ManoObraCentroCostoController::class, 'crearManoObraCentroCosto']);
    Route::post('/actualizarManoObraCentroCosto', [ManoObraCentroCostoController::class, 'actualizarManoObraCentroCosto']);
    Route::post('/borrarManoObraCentroCosto', [ManoObraCentroCostoController::class, 'borrarManoObraCentroCosto']);
    Route::post('/getManoObraCentroCosto', [ManoObraCentroCostoController::class, 'getManoObraCentroCosto']);
    Route::post('/getManoObraCentroCostoEspecifico', [ManoObraCentroCostoController::class, 'getManoObraCentroCostoEspecifico']);

    Route::post('/crearRecDirectosActividad', [RecDirectosActividadController::class, 'crearRecDirectosActividad']);
    Route::post('/actualizarRecDirectosActividad', [RecDirectosActividadController::class, 'actualizarRecDirectosActividad']);
    Route::post('/getRecActividadManoObra', [RecDirectosActividadController::class, 'getRecActividadManoObra']);
    Route::post('/getRecActividadManoObraCompleto', [RecDirectosActividadController::class, 'getRecActividadManoObraCompleto']);
    Route::post('/getRecActividadManoObraCompletoSinCco', [RecDirectosActividadController::class, 'getRecActividadManoObraCompletoSinCco']);
    Route::post('/getRecActividadSuministros', [RecDirectosActividadController::class, 'getRecActividadSuministros']);
    Route::post('/getRecActividadSuministrosCompleto', [RecDirectosActividadController::class, 'getRecActividadSuministrosCompleto']);
    Route::post('/getRecActividadSuministrosCompletoSinCco', [RecDirectosActividadController::class, 'getRecActividadSuministrosCompletoSinCco']);
    Route::post('/validarAvanceCcoRecursosActividad', [RecDirectosActividadController::class, 'validarAvanceCentrosCosto']);

    Route::post('/crearContratoEps', [ContratosEpsController::class, 'crearContratoEps']);
    Route::post('/actualizarContratoEps', [ContratosEpsController::class, 'actualizarContratoEps']);
    Route::post('/getContratosEps', [ContratosEpsController::class, 'getContratosEps']);
    Route::post('/getContratosEpsSinEAPB', [ContratosEpsController::class, 'getContratosEpsSinEAPB']);
    Route::post('/getEntidadesContratos', [ContratosEpsController::class, 'getEntidadesContratos']);
    Route::post('/getContratoEpsPorNumero', [ContratosEpsController::class, 'getContratoEpsPorNumero']);
    Route::post('/getContratoEpsPorNumeroNit', [ContratosEpsController::class, 'getContratoEpsPorNumeroNit']);
    Route::post('/inhabilitarContratoEps', [ContratosEpsController::class, 'inhabilitarContrato']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api'], 'prefix' => 'miempresa'], function() {
    Route::post('/cargarArchivoCentroUtilidad', [CentrosUtilidadController::class, 'cargarArchivoCentrosUtilidad']);
    Route::post('/cargarArchivoSubcentroUtilidad', [SubcentrosUtilidadController::class, 'cargarArchivoSubcentrosUtilidad']);
    Route::post('/cargarArchivoCentroCosto', [CentrosCostoController::class, 'cargarArchivoCentrosCosto']);
    Route::post('/cargarArchivoDetalleElementos', [DetalleElementosController::class, 'cargarArchivoDetalleElementos']);
    Route::post('/cargarArchivoCuentasContables', [CuentasContablesController::class, 'cargarArchivoCuentasContables']);
    Route::post('/cargarArchivoActividades', [ActividadesController::class, 'cargarArchivoActividades']);
    Route::post('/cargarArchivoActividadesCentroCosto', [ActividadesCentroCostoController::class, 'cargarArchivoActividadesCentroCosto']);
    Route::post('/cargarArchivoBasesDistribucion', [BasesDistribucionController::class, 'cargarArchivoBasesDistribucion']);
    Route::post('/cargarArchivoGrupoSuministros', [GrupoSuministrosController::class, 'cargarArchivoGrupoSuministros']);
    Route::post('/cargarArchivoRelCucGrSuministros', [RelCucGrSuministrosController::class, 'cargarArchivoRelCucGrSuministros']);
    Route::post('/cargarArchivoSuministros', [SuministrosController::class, 'cargarArchivoSuministros']);
    Route::post('/cargarArchivoSuministrosCentroCosto', [SuministrosCentroCostoController::class, 'cargarArchivoSuministrosCentroCosto']);
    Route::post('/cargarArchivoManoObra', [ManoObraController::class, 'cargarArchivoManoObra']);
    Route::post('/cargarArchivoManoObraCentroCosto', [ManoObraCentroCostoController::class, 'cargarArchivoManoObraCentroCosto']);
    Route::post('/cargarArchivoContratosEps', [ContratosEpsController::class, 'cargarArchivoContratosEps']);
    Route::post('/cargarArchivoRecDirectosActividad', [RecDirectosActividadController::class, 'cargarArchivoRecursosDirectosActividad']);
    Route::post('/cargarArchivoGestionProgramas', [GestionProgramasController::class, 'cargarArchivoGestionPaquetes']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api', 'checkToken'], 'prefix' => 'costeoCentroCosto'], function() {
    Route::post('/crearMovimientoIfm', [InformacionFinancieraController::class, 'crearMovimientoInfoFinanciera']);
    Route::post('/crearDistribucionCostosIfm', [InformacionFinancieraController::class, 'crearDistribucionCostosIfm']);
    Route::post('/actualizarDistribucionCostosIfm', [InformacionFinancieraController::class, 'actualizarDistribucionCostosIfm']);
    Route::post('/aprobarMasivamenteIfm', [InformacionFinancieraController::class, 'aprobarMasivamente']);
    Route::post('/importarIfmMesAnterior', [InformacionFinancieraController::class, 'importarInformacionMesAnterior']);
    Route::post('/getInformacionFinanciera', [InformacionFinancieraController::class, 'getInformacionFinanciera']);
    Route::post('/getValorIfmTipoCuenta', [InformacionFinancieraController::class, 'getValorIfmTipoCuenta']);
    Route::post('/getDsitribucionIfmCostosCuentas', [InformacionFinancieraController::class, 'getDistribucionIfmCuentas']);
    Route::post('/getDsitribucionIfmCostosBases', [InformacionFinancieraController::class, 'getDistribucionIfmBases']);
    Route::post('/getDistribucionValorDirecto', [InformacionFinancieraController::class, 'getDistribucionValorDirecto']);
    Route::post('/getMovimientosValorDirecto', [InformacionFinancieraController::class, 'getMovimientosValorDirecto']);
    Route::post('/getValorTotalMovimientos', [InformacionFinancieraController::class, 'getValorTotalMovimientos']);
    Route::post('/getDistIfmCentrosCostoCompleto', [InformacionFinancieraController::class, 'getDistribucionCentrosCostosCompleto']);
    Route::post('/getDistIfmBasesDistribucionCompleto', [InformacionFinancieraController::class, 'getDistribucionBasesDistribucionCompleto']);

    Route::post('/crearInfoBasesDistribucion', [InformacionBasesDistribucionController::class, 'crearInfoBasesDistribucion']);
    Route::post('/actualizarInfoBasesDistribucion', [InformacionBasesDistribucionController::class, 'actualizarInfoBasesDistribucion']);
    Route::post('/borrarInfoBasesDistribucion', [InformacionBasesDistribucionController::class, 'borrarInfoBasesDistribucion']);
    Route::post('/getInfoBasesDistribucion', [InformacionBasesDistribucionController::class, 'getInfoBasesDistribucion']);
    Route::post('/getInfoBasesDistribucionEspecifica', [InformacionBasesDistribucionController::class, 'getInfoBasesDistribucionEspecifica']);
    Route::post('/importarInformacionIbd', [InformacionBasesDistribucionController::class, 'importarInformacionMesAnterior']);

    Route::post('/getInformacionProduccion', [InformacionProduccionController::class, 'getInformacionProduccion']);
    Route::post('/borrarInformacionProduccion', [InformacionProduccionController::class, 'borrarInformacionProduccion']);

    Route::post('/consolidarRecursosCentroCosto', [RecursosCentroCostoController::class, 'consolidarRecursosCentroCosto']);
    Route::post('/getRecursosCentroCosto', [RecursosCentroCostoController::class, 'getRecursosCentroCosto']);

    Route::post('/getCostoPrimario', [CostoPrimarioController::class, 'getCostoPrimario']);
    Route::post('/getCostoPrimarioMeses', [CostoPrimarioController::class, 'getCostoPrimarioMeses']);

    Route::post('/consolidarCostoDistribuido', [CostoDistribuidoController::class, 'consolidarCostoDistribuido']);
    Route::post('/getCostoDistribuido', [CostoDistribuidoController::class, 'getCostoDistribuido']);

    Route::post('/getCostoTotal', [CostoTotalController::class, 'getCostoTotal']);
    Route::post('/getCostoTotalMeses', [CostoTotalController::class, 'getCostoTotalMeses']);

    Route::post('/getManoObraTerceros', [ManoObraTercerosController::class, 'getManoObraTerceros']);
    Route::post('/consolidarManoObraTerceros', [ManoObraTercerosController::class, 'consolidarManoObraTerceros']);
    Route::post('/devolverMovimientoImo', [ManoObraTercerosController::class, 'devolverMovimiento']);

    Route::post('/crearInformacionManoObra', [InformacionManoObraController::class, 'crearInformacionManoObra']);
    Route::post('/actualizarInformacionManoObra', [InformacionManoObraController::class, 'actualizarInformacionManoObra']);
    Route::post('/getCargosTercero', [InformacionManoObraController::class, 'getCargosTercero']);
    Route::post('/getInformacionManoObra', [InformacionManoObraController::class, 'getInformacionManoObra']);
    Route::post('/getInformacionManoObraCompleta', [InformacionManoObraController::class, 'getInformacionManoObraCompleta']);
    Route::post('/borrarCargoTercero', [InformacionManoObraController::class, 'borrarCargoTercero']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api'], 'prefix' => 'costeoCentroCosto'], function() {
    Route::post('/cargarArchivoInformacionFinanciera', [InformacionFinancieraController::class, 'cargarArchivoInformacionFinanciera']);
    Route::post('/cargarArchivoInformacionBasesDistribucion', [InformacionBasesDistribucionController::class, 'cargarArchivoInfoBasesDistribucion']);
    Route::post('/cargarArchivoInformacionManoObra', [InformacionManoObraController::class, 'cargarArchivoInformacionManoObra']);
    Route::post('/cargarArchivoInformacionCostoCargo', [InformacionManoObraController::class, 'cargarArchivoInformacionCostoCargo']);
    Route::post('/cargarArchivoInformacionProduccion', [InformacionProduccionController::class, 'cargarArchivoInformacionProduccion']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api', 'checkToken'], 'prefix' => 'costeoUnitario'], function() {
    Route::post('/consolidarValorMinuto', [ValorMinutoController::class, 'consolidarValorMinuto']);
    Route::post('/getValorMinuto', [ValorMinutoController::class, 'getValorMinuto']);
    Route::post('/getValorMinutoCargo', [ValorMinutoController::class, 'getValorMinutoCargo']);
    Route::post('/getValorMinutoCentroCosto', [ValorMinutoController::class, 'getValorMinutoCentroCosto']);
    Route::post('/getDistribucionValorMinuto', [ValorMinutoController::class, 'getDistribucionHorasCentro']);
    Route::post('/getRankingValorMinuto', [ValorMinutoController::class, 'getRankingValorMinuto']);

    Route::post('/consolidarTasaRecursosIndirectos', [TasaRecursosIndirectosController::class, 'consolidarTasaRecursosIndirectos']);
    Route::post('/getTasaRecursosIndirectos', [TasaRecursosIndirectosController::class, 'getTasaRecursosIndirectos']);

    Route::post('/crearDetalleSuministros', [DetalleSuministrosController::class, 'crearDetalleSuministros']);
    Route::post('/actualizarDetalleSuministros', [DetalleSuministrosController::class, 'actualizarDetalleSuministos']);
    Route::post('/borrarDetalleSuministros', [DetalleSuministrosController::class, 'borrarDetalleSuministros']);
    Route::post('/getDetalleSuministros', [DetalleSuministrosController::class, 'getDetalleSuministros']);
    Route::post('/getDetalleSuministrosEspecifico', [DetalleSuministrosController::class, 'getDetalleSuministrosEspecifico']);

    Route::post('/getDetallePobPrograma', [DetallePobProgramaController::class, 'getDetallePobPrograma']);

    Route::post('/consolidarCostoUnitario', [CostoUnitarioController::class, 'consolidarCostoUnitario']);
    Route::post('/getManoObraDirecta', [CostoUnitarioController::class, 'getManoObraDirecta']);
    Route::post('/getSuministrosDirectos', [CostoUnitarioController::class, 'getSuministrosDirectos']);
    Route::post('/getCostoUnitario', [CostoUnitarioController::class, 'getCostoUnitario']);
    Route::post('/getCostoUnitarioMeses', [CostoUnitarioController::class, 'getCostoUnitarioMeses']);

    Route::post('/getCostoUnitarioAjustado', [CostoUnitarioAjustadoController::class, 'getCostoUnitarioAjustado']);
    Route::post('/getCostoPaquetes', [CostoPaquetesController::class, 'getCostoPaquetes']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api'], 'prefix' => 'costeoUnitario'], function() {
    Route::post('/cargarArchivoDetalleSuministros', [DetalleSuministrosController::class, 'cargarArchivoDetalleSuministros']);
    Route::post('/cargarArchivoDetallePobPrograma', [DetallePobProgramaController::class, 'cargarArchivoDetallePobPrograma']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api'], 'prefix' => 'programas'], function() {
    Route::post('/consolidarCostoProgramasPresupuestado', [ProgramasController::class, 'consolidarCostoProgramasPresupuestado']);
    Route::post('/obtenerCostoProgramasPresupuestado', [ProgramasController::class, 'obtenerCostoProgramaPrespuestado']);
    Route::post('/consolidarCostoProgramasEjecutado', [ProgramasController::class, 'consolidarCostoProgramasEjecutado']);
    Route::post('/obtenerCostoProgramasEjecutado', [ProgramasController::class, 'obtenerCostoProgramaEjecutado']);
    Route::post('/obtenerDetalleCostoProgramasEjecutado', [ProgramasController::class, 'obtenerDetalleCostoProgramaEjecutado']);
    Route::post('/obtenerComparativoCostoProgramadoEjecutado', [ProgramasController::class, 'obtenerComparativoCostoProgramadoEjecutado']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api', 'checkToken'], 'prefix' => 'monitorContratos'], function() {
    Route::post('/consolidarInfoContratos', [MonitorContratosController::class, 'consolidarInformacionContratos']);
    Route::post('/getDetalleMonitorActividades', [MonitorContratosController::class, 'getDetalleMonitorActividades']);
    Route::post('/getDetalleMonitorSuministros', [MonitorContratosController::class, 'getDetalleMonitorSuministros']);
    Route::post('/getAnalisisResultadoMargen', [MonitorContratosController::class, 'getAnalisisResultadoMargen']);
    Route::post('/getVentasCostosContratos', [MonitorContratosController::class, 'getResumenCostosVentas']);
    Route::post('/getAnalisisResultadoMargenCco', [MonitorContratosController::class, 'getAnalisisResultadoMargenCco']);
    Route::post('/getAnalisisEjecucion', [MonitorContratosController::class, 'getAnalisisEjecucion']);
});

Route::group(['middleware' => ['auth:api', 'cors', 'scopes:api', 'checkToken'], 'prefix' => 'costosIngresos'], function() {
    Route::post('/getBalanceGeneral', [CostosIngresosController::class, 'getBalanceGeneral']);
    Route::post('/getBalanceGeneralAcumulado', [CostosIngresosController::class, 'getBalanceGeneralAcumulado']);
    Route::post('/getBalanceSedes', [CostosIngresosController::class, 'getBalanceSedes']);
    Route::post('/getBalanceSedesAcumulado', [CostosIngresosController::class, 'getBalanceSedesAcumulado']);
    Route::post('/getBalanceCentrosUtilidad', [CostosIngresosController::class, 'getBalanceCentrosUtilidad']);
    Route::post('/getBalanceCentrosUtilidadAcumulado', [CostosIngresosController::class, 'getBalanceCentrosUtilidadAcumulado']);
    Route::post('/getBalanceCentrosCosto', [CostosIngresosController::class, 'getBalanceCentrosCosto']);
    Route::post('/getBalanceCentrosCostoAcumulado', [CostosIngresosController::class, 'getBalanceCentrosCostoAcumulado']);
    Route::post('/getComposicionCosto', [ComposicionCostoController::class, 'getComposicionCosto']);
    Route::post('/getComposicionCostoSedes', [ComposicionCostoController::class, 'getComposicionCostoSedes']);
    Route::post('/getComposicionCostoCentroUtilidad', [ComposicionCostoController::class, 'getComposicionCostoCentroUtilidad']);
    Route::post('/getComposicionCostoCentroCosto', [ComposicionCostoController::class, 'getComposicionCostoCentroCosto']);
    Route::post('/getDistribucionCosto', [DistribucionCostoController::class, 'getDistribucionCosto']);
    Route::post('/getDistribucionCostoSubcentro', [DistribucionCostoController::class, 'getDistribucionCostoSubcentro']);
    Route::post('/getCostoUnitarioPromedio', [CostoUnitarioPromedioController::class, 'getCostoUnitarioPromedio']);
    Route::post('/getAnalisisCostoVolumen', [AnalisisCostoVolumenController::class, 'getAnalisisCostoVolumen']);
    Route::post('/getDetalleCpManoObra', [DetalleCostoPrimarioController::class, 'getDetalleCostoPrimarioManoObra']);
    Route::post('/getDetalleCpSuministros', [DetalleCostoPrimarioController::class, 'getDetalleCostoPrimarioSuministros']);
    Route::post('/getDetalleCpGastosGen', [DetalleCostoPrimarioController::class, 'getDetalleCostoPrimarioGastos']);
});
