<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoPrgPaquetes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_prg_paquetes', function (Blueprint $table) {
            $table->bigIncrements('cpp_pk_id');

            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cpp_ano');
            $table->integer('cpp_mes');

            $table->integer('prg_fk_id');
            $table->integer('coe_fk_id');
            $table->integer('sed_fk_id');
            $table->integer('esp_fk_id');

            $table->integer('act_fk_id');

            $table->float('cpp_costo_mob_dir_paquete')->nullable();
            $table->float('cpp_costo_mob_indir_paquete')->nullable();
            $table->float('cpp_costo_sum_dir_paquete')->nullable();
            $table->float('cpp_costo_sum_indir_paquete')->nullable();
            $table->float('cpp_costo_ggen_paquete')->nullable();
            $table->float('cpp_costo_cdist_paquete')->nullable();
            $table->float('cpp_costo_paquete')->nullable();

            $table->index(['con_fk_id', 'ins_fk_id', 'cpp_ano', 'cpp_mes', 'prg_fk_id', 'act_fk_id'], 'c_prg_p_index1');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costo_prg_paquetes');
    }
}
