<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoUnitarioAjustado extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_unitario_ajustado', function (Blueprint $table) {
            $table->increments('cua_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cua_ano');
            $table->integer('cua_mes');
            $table->integer('cco_fk_id');
            $table->integer('act_fk_id');
            $table->float('cua_mob_directa')->nullable();
            $table->float('cua_mob_indirecta')->nullable();
            $table->float('cua_sum_directo')->nullable();
            $table->float('cua_sum_indirecto')->nullable();
            $table->float('cua_gastos_gen')->nullable();
            $table->float('cua_costo_dist')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('act_fk_id')->references('act_pk_id')->on('actividades')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'cua_ano', 'cua_mes', 'cco_fk_id', 'act_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'cua_ano', 'cua_mes'], 'cua_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'cua_ano', 'cua_mes', 'cco_fk_id'], 'cua_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'cua_ano', 'cua_mes', 'cco_fk_id', 'act_fk_id'], 'cua_index3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costo_unitario_ajustado');
    }
}
