<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ActividadesCentroCosto extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('actividades_centro_costo', function (Blueprint $table) {
            $table->increments('acc_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('acc_ano');
            $table->integer('cco_fk_id');
            $table->integer('act_fk_id');
            $table->boolean('acc_suma_produccion');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('act_fk_id')->references('act_pk_id')->on('actividades')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'acc_ano', 'act_fk_id', 'cco_fk_id'], 'acc_unique');
            $table->index(['con_fk_id', 'ins_fk_id', 'acc_ano'], 'acc_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'acc_ano', 'cco_fk_id'], 'acc_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'acc_ano', 'cco_fk_id', 'act_fk_id'], 'acc_index3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('actividades_centro_costo');
    }
}
