<?php

namespace App\Http\Controllers;

use App\Models\RecActividadManoObra;
use App\Models\RecActividadSuministros;
use App\Models\ActividadesCentroCosto;
use App\Models\ManoObra;
use App\Models\Suministros;
use App\Models\CentrosCosto;
use App\Models\Actividades;
use Illuminate\Http\Request;

class RecDirectosActividadController extends Controller
{
    private $apiKey;

    function __construct() {
        $apiController = new ApiController();

        $this->apiKey = $apiController->getApiKey()["key"];
    }

    public function crearRecDirectosActividad(Request $request) {
        \DB::transaction(function() use ($request) {
            $relMob = RecActividadManoObra::on('costos_principal');
            $relSum = RecActividadSuministros::on('costos_principal');

            $manoObra = json_decode($request->input('manoObra'));
            $suministros = json_decode($request->input('suministros'));

            foreach ($manoObra as $mob) {
                $id = $relMob->create(
                    [
                        "con_fk_id" => $request->input("con_fk_id"),
                        "ins_fk_id" => $request->input("ins_fk_id"),
                        "ram_ano" => $request->input("rda_ano"),
                        "cco_fk_id" => $request->input("cco_fk_id"),
                        "act_fk_id" => $request->input("act_fk_id"),
                        "mob_fk_id" => $mob->mob_fk_id,
                        "ram_unidad_medida" => $mob->ram_unidad_medida,
                        "ram_unidad_consumo" => $mob->ram_unidad_consumo,
                        "ram_relacion" => $mob->ram_relacion,
                        "ram_factor_conversion" => $mob->ram_relacion !== null ? 1 / $mob->ram_relacion : null,
                        "ram_consumo_actividad" => $mob->ram_consumo_actividad,
                        "ram_valor_actividad" =>  $mob->ram_valor_actividad
                    ]
                );
            }

            foreach ($suministros as $sum) {
                $id = $relSum->create(
                    [
                        "con_fk_id" => $request->input("con_fk_id"),
                        "ins_fk_id" => $request->input("ins_fk_id"),
                        "ras_ano" => $request->input("rda_ano"),
                        "cco_fk_id" => $request->input("cco_fk_id"),
                        "act_fk_id" => $request->input("act_fk_id"),
                        "sum_fk_id" => $sum->sum_fk_id,
                        "ras_unidad_medida" => $sum->ras_unidad_medida,
                        "ras_unidad_consumo" => $sum->ras_unidad_consumo,
                        "ras_relacion" => $sum->ras_relacion,
                        "ras_factor_conversion" => 1 / $sum->ras_relacion,
                        "ras_consumo_actividad" => $sum->ras_consumo_actividad
                    ]
                );
            }
        });

        return array("response" => 1);
    }

    public function actualizarRecDirectosActividad(Request $request) {
        \DB::transaction(function() use ($request) {
            RecActividadManoObra::on('costos_principal')
                            ->where('con_fk_id', $request->input('con_fk_id'))
                            ->where('ins_fk_id', $request->input('ins_fk_id'))
                            ->where('ram_ano', $request->input('rda_ano'))
                            ->where('act_fk_id', $request->input('act_fk_id'))
                            ->delete();

            RecActividadSuministros::on('costos_principal')
                               ->where('con_fk_id', $request->input('con_fk_id'))
                               ->where('ins_fk_id', $request->input('ins_fk_id'))
                               ->where('ras_ano', $request->input('rda_ano'))
                               ->where('act_fk_id', $request->input('act_fk_id'))
                               ->delete();

            $relMob = RecActividadManoObra::on('costos_principal');
            $relSum = RecActividadSuministros::on('costos_principal');

            $manoObra = json_decode($request->input('manoObra'));
            $suministros = json_decode($request->input('suministros'));

            foreach ($manoObra as $mob) {
                $id = $relMob->create(
                    [
                        "con_fk_id" => $request->input("con_fk_id"),
                        "ins_fk_id" => $request->input("ins_fk_id"),
                        "ram_ano" => $request->input("rda_ano"),
                        "cco_fk_id" => $request->input("cco_fk_id"),
                        "act_fk_id" => $request->input("act_fk_id"),
                        "mob_fk_id" => $mob->mob_fk_id,
                        "ram_unidad_medida" => $mob->ram_unidad_medida,
                        "ram_unidad_consumo" => $mob->ram_unidad_consumo,
                        "ram_relacion" => $mob->ram_relacion,
                        "ram_factor_conversion" => $mob->ram_relacion !== null ? 1 / $mob->ram_relacion : null,
                        "ram_consumo_actividad" => $mob->ram_consumo_actividad,
                        "ram_valor_actividad" =>  $mob->ram_valor_actividad
                    ]
                );
            }

            foreach ($suministros as $sum) {
                $id = $relSum->create(
                    [
                        "con_fk_id" => $request->input("con_fk_id"),
                        "ins_fk_id" => $request->input("ins_fk_id"),
                        "ras_ano" => $request->input("rda_ano"),
                        "cco_fk_id" => $request->input("cco_fk_id"),
                        "act_fk_id" => $request->input("act_fk_id"),
                        "sum_fk_id" => $sum->sum_fk_id,
                        "ras_unidad_medida" => $sum->ras_unidad_medida,
                        "ras_unidad_consumo" => $sum->ras_unidad_consumo,
                        "ras_relacion" => $sum->ras_relacion,
                        "ras_factor_conversion" => 1 / $sum->ras_relacion,
                        "ras_consumo_actividad" => $sum->ras_consumo_actividad
                    ]
                );
            }
        });

        return array("response" => 1);
    }

    public function getRecActividadManoObra(Request $request) {
        return RecActividadManoObra::on('costos_principal')
                                   ->join('mano_obra', 'mob_pk_id', '=', 'mob_fk_id')
                                   ->where('rec_actividad_mano_obra.con_fk_id', $request->input('con_fk_id'))
                                   ->where('rec_actividad_mano_obra.ins_fk_id', $request->input('ins_fk_id'))
                                   ->where('ram_ano', $request->input('ram_ano'))
                                   ->where('cco_fk_id', $request->input('cco_fk_id'))
                                   ->where('act_fk_id', $request->input('act_fk_id'))
                                   ->get()->toArray();
    }

    public function getRecActividadManoObraCompleto(Request $request) {
        return RecActividadManoObra::on('costos_principal')
                                   ->join('mano_obra', 'mob_pk_id', '=', 'mob_fk_id')
                                   ->where('rec_actividad_mano_obra.con_fk_id', $request->input('con_fk_id'))
                                   ->where('rec_actividad_mano_obra.ins_fk_id', $request->input('ins_fk_id'))
                                   ->where('ram_ano', $request->input('ram_ano'))
                                   ->where('cco_fk_id', $request->input('cco_fk_id'))
                                   ->get()->toArray();
    }

    public function getRecActividadManoObraCompletoSinCco(Request $request) {
        return RecActividadManoObra::on('costos_principal')
                                   ->join('mano_obra', 'mob_pk_id', '=', 'mob_fk_id')
                                   ->join('centros_costo', 'cco_pk_id', '=', 'cco_fk_id')
                                   ->join('actividades', 'act_pk_id', '=', 'act_fk_id')
                                   ->where('rec_actividad_mano_obra.con_fk_id', $request->input('con_fk_id'))
                                   ->where('rec_actividad_mano_obra.ins_fk_id', $request->input('ins_fk_id'))
                                   ->where('ram_ano', $request->input('ram_ano'))
                                   ->get()->toArray();
    }

    public function getRecActividadSuministros(Request $request) {
        return RecActividadSuministros::on('costos_principal')
                                      ->join('suministros', 'sum_pk_id', '=', 'sum_fk_id')
                                      ->where('rec_actividad_suministros.con_fk_id', $request->input('con_fk_id'))
                                      ->where('rec_actividad_suministros.ins_fk_id', $request->input('ins_fk_id'))
                                      ->where('ras_ano', $request->input('ras_ano'))
                                      ->where('cco_fk_id', $request->input('cco_fk_id'))
                                      ->where('act_fk_id', $request->input('act_fk_id'))
                                      ->get()->toArray();
    }

    public function getRecActividadSuministrosCompleto(Request $request) {
        return RecActividadSuministros::on('costos_principal')
                                      ->join('suministros', 'sum_pk_id', '=', 'sum_fk_id')
                                      ->where('rec_actividad_suministros.con_fk_id', $request->input('con_fk_id'))
                                      ->where('rec_actividad_suministros.ins_fk_id', $request->input('ins_fk_id'))
                                      ->where('ras_ano', $request->input('ras_ano'))
                                      ->where('cco_fk_id', $request->input('cco_fk_id'))
                                      ->get()->toArray();
    }

    public function getRecActividadSuministrosCompletoSinCco(Request $request) {
        return RecActividadSuministros::on('costos_principal')
                                      ->join('suministros', 'sum_pk_id', '=', 'sum_fk_id')
                                      ->join('centros_costo', 'cco_pk_id', '=', 'cco_fk_id')
                                      ->join('actividades', 'act_pk_id', '=', 'act_fk_id')
                                      ->where('rec_actividad_suministros.con_fk_id', $request->input('con_fk_id'))
                                      ->where('rec_actividad_suministros.ins_fk_id', $request->input('ins_fk_id'))
                                      ->where('ras_ano', $request->input('ras_ano'))
                                      ->get()->toArray();
    }

    public function cargarArchivoRecursosDirectosActividad(Request $request) {
        $apiKey = $request->apiKey;

        if ($apiKey === $this->apiKey) {
            $rutaDelArchivo = $request->recursosDirectosActividad->path();
            $delimitador = $request->delimitador;
            $archivo = fopen($rutaDelArchivo, 'r');
            $recursosDirectosActividad = array();
            $primeraLinea = true;

            // Extraer cada línea del archivo CSV y convertirlo en un arreglo
            while($linea = fgetcsv($archivo, 1000, $delimitador)) {
                if (!$primeraLinea) {
                    $registro = $linea;
                    array_push($recursosDirectosActividad, $registro);
                } else {
                    $primeraLinea = false;
                }
            }

            fclose($archivo);

            // Verificar duplicados en el archivo
            $duplicados = $this->buscarDuplicadosCargaaCsv($recursosDirectosActividad);

            if ($duplicados["sum"] != "" || $duplicados["mob"] != "") {
                $resultados = new \stdClass();

                $resultados->correcto = false;
                $resultados->duplicados = true;
                $resultados->dupSuministros = $duplicados["sum"];
                $resultados->dupCargos = $duplicados["mob"];

                return json_encode($resultados);
            } else {
                return $this->procesarArchivoRecursosDirectosActividad($recursosDirectosActividad,
                                                                       $request->con_fk_id,
                                                                       $request->ins_fk_id,
                                                                       $request->rda_ano);
            }
        } else {
            throw new \Exception('Imposible completar la petición.');
        }
    }

    private function procesarArchivoRecursosDirectosActividad($recDirActividad, $con_fk_id, $ins_fk_id, $rda_ano) {
        $resultados = new \stdClass();
        $resultados->errores = "";
        $resultados->duplicados = false;

        // Revisar si hay registros duplicados

        \DB::transaction(function() use(&$resultados, $recDirActividad, $con_fk_id, $ins_fk_id, $rda_ano) {
            if (count($recDirActividad) === 0) {
                $resultados->correcto = false;
                $resultados->errores = 'El archivo está vacío. ';
                return json_encode($resultados);
            } else if (count($recDirActividad[0]) !== 8) {
                $resultados->correcto = false;
                $resultados->errores = 'La cantidad de columnas no corresponde. ';
                return json_encode($resultados);
            } else {
                $centrosCostoBd = CentrosCosto::on('costos_principal')
                                              ->where('con_fk_id', $con_fk_id)
                                              ->where('ins_fk_id', $ins_fk_id)
                                              ->where('cco_ano', $rda_ano)
                                              ->where('cco_final', true)
                                              ->get()->toArray();

                $actividadesBd = Actividades::on('costos_principal')
                                            ->where('con_fk_id', $con_fk_id)
                                            ->where('ins_fk_id', $ins_fk_id)
                                            ->where('act_ano', $rda_ano)
                                            ->get()->toArray();

                $actividadesCentrosCostoBd = ActividadesCentroCosto::on('costos_principal')
                                                                   ->join('centros_costo', 'cco_fk_id', '=', 'cco_pk_id')
                                                                   ->join('actividades', 'act_fk_id', '=', 'act_pk_id')
                                                                   ->where('actividades_centro_costo.con_fk_id', $con_fk_id)
                                                                   ->where('actividades_centro_costo.ins_fk_id', $ins_fk_id)
                                                                   ->where('acc_ano', $rda_ano)
                                                                   ->get()->toArray();

                $manoObraBd = ManoObra::on('costos_principal')
                                      ->where('con_fk_id', $con_fk_id)
                                      ->where('ins_fk_id', $ins_fk_id)
                                      ->where('mob_ano', $rda_ano)
                                      ->get()->toArray();

                $suministrosBd = Suministros::on('costos_principal')
                                            ->where('con_fk_id', $con_fk_id)
                                            ->where('ins_fk_id', $ins_fk_id)
                                            ->where('sum_ano', $rda_ano)
                                            ->get()->toArray();

                $recActManoObra = RecActividadManoObra::on('costos_principal')
                                                      ->join('centros_costo', 'cco_fk_id', '=', 'cco_pk_id')
                                                      ->join('actividades', 'act_fk_id', '=', 'act_pk_id')
                                                      ->where('rec_actividad_mano_obra.con_fk_id', $con_fk_id)
                                                      ->where('rec_actividad_mano_obra.ins_fk_id', $ins_fk_id)
                                                      ->where('ram_ano', $rda_ano)
                                                      ->get()->toArray();

                $recActSuministros = RecActividadSuministros::on('costos_principal')
                                                            ->join('centros_costo', 'cco_fk_id', '=', 'cco_pk_id')
                                                            ->join('actividades', 'act_fk_id', '=', 'act_pk_id')
                                                            ->where('rec_actividad_suministros.con_fk_id', $con_fk_id)
                                                            ->where('rec_actividad_suministros.ins_fk_id', $ins_fk_id)
                                                            ->where('ras_ano', $rda_ano)
                                                            ->get()->toArray();

                $centrosCostoExistentes = [];
                $actividadesExistentes = [];
                $actCentroCostoExistentes = [];
                $manoObraExistente = [];
                $suministrosExistentes = [];
                $recActManoObraExistente = [];
                $recActSuministrosExistente = [];
                $registrosProcesados = 0;

                // Crear las relaciones existentes en la base de datos
                foreach ($centrosCostoBd as $ccoDb) {
                    $centrosCostoExistentes[$ccoDb['cco_cod_homologado']] = $ccoDb['cco_pk_id'];
                }

                foreach ($actividadesBd as $actDb) {
                    $actividadesExistentes[$actDb['act_codigo']] = $actDb['act_pk_id'];
                }

                foreach ($actividadesCentrosCostoBd as $accDb) {
                    $actCentroCostoExistentes[$accDb['cco_cod_homologado']][$accDb['act_codigo']] = $accDb['acc_pk_id'];
                }

                foreach ($manoObraBd as $mobDb) {
                    $manoObraExistente[$mobDb['mob_codigo']] = $mobDb['mob_pk_id'];
                }

                foreach ($suministrosBd as $sumDb) {
                    $suministrosExistentes[$sumDb['sum_codigo']] = new \stdClass();

                    $suministrosExistentes[$sumDb['sum_codigo']]->sum_pk_id = $sumDb['sum_pk_id'];
                    $suministrosExistentes[$sumDb['sum_codigo']]->sum_unidad_medida = $sumDb['sum_unidad_medida'];
                }

                foreach ($recActManoObra as $ramDb) {
                    $recActManoObraExistente[$ramDb['cco_cod_homologado']][$ramDb['act_codigo']][$ramDb['mob_fk_id']] = new \stdClass();

                    $recActManoObraExistente[$ramDb['cco_cod_homologado']][$ramDb['act_codigo']][$ramDb['mob_fk_id']]->ram_unidad_consumo = $ramDb['ram_unidad_consumo'];
                    $recActManoObraExistente[$ramDb['cco_cod_homologado']][$ramDb['act_codigo']][$ramDb['mob_fk_id']]->ram_relacion = $ramDb['ram_relacion'];
                    $recActManoObraExistente[$ramDb['cco_cod_homologado']][$ramDb['act_codigo']][$ramDb['mob_fk_id']]->ram_consumo_actividad = $ramDb['ram_consumo_actividad'];
                    $recActManoObraExistente[$ramDb['cco_cod_homologado']][$ramDb['act_codigo']][$ramDb['mob_fk_id']]->ram_valor_actividad = $ramDb['ram_valor_actividad'];
                }

                foreach ($recActSuministros as $rasDb) {
                    $recActSuministrosExistente[$rasDb['cco_cod_homologado']][$rasDb['act_codigo']][$rasDb['sum_fk_id']] = new \stdClass();

                    $recActSuministrosExistente[$rasDb['cco_cod_homologado']][$rasDb['act_codigo']][$rasDb['sum_fk_id']]->ras_unidad_consumo = $rasDb['ras_unidad_consumo'];
                    $recActSuministrosExistente[$rasDb['cco_cod_homologado']][$rasDb['act_codigo']][$rasDb['sum_fk_id']]->ras_relacion = $rasDb['ras_relacion'];
                    $recActSuministrosExistente[$rasDb['cco_cod_homologado']][$rasDb['act_codigo']][$rasDb['sum_fk_id']]->ras_consumo_actividad = $rasDb['ras_consumo_actividad'];
                }

                // Errores de los centros de utilidad
                $actCentrosCostoInexistentes = "";
                $manoObraInexistente = "";
                $suministrosInexistentes = "";
                $tiposInexistentes = false;
                $descripcionLargas = false;
                $valoresIncorrectos = false;
                $camposVacios = false;

                // Revisar el archivo respecto a las relaciones existentes
                foreach($recDirActividad as $rdaCsv) {
                    $centroCosto = strtoupper(trim($rdaCsv[0]));
                    $actividad = strtoupper(trim($rdaCsv[1]));
                    $tipo = strtoupper(trim($rdaCsv[2]));
                    $mobSum = strtoupper(trim($rdaCsv[3]));
                    $unidadConsumo = trim($rdaCsv[4]);
                    $relacion = trim($rdaCsv[5]);
                    $cantidad = trim($rdaCsv[6]);
                    $valorActividad = trim($rdaCsv[7]);

                    // Campos vacíos
                    if ($centroCosto != "" && $actividad != "" && $tipo != "" && $mobSum != "" && (($unidadConsumo != "" && $relacion != "" && $cantidad != "") || $valorActividad !== "")) {
                        // Descripciones largas
                        if (strlen($unidadConsumo) <= 80) {
                            // Existe la relacion centro de costo - actividad
                            if (isset($actCentroCostoExistentes[$centroCosto][$actividad])) {
                                // Existe el tipo
                                if ($tipo == "S" || $tipo == "M") {
                                    // Existe la mano de obra o suministro
                                    if (($tipo == "M" && isset($manoObraExistente[$mobSum])) || ($tipo == "S" && isset($suministrosExistentes[$mobSum]))) {
                                        // Valores incorrectos
                                        if ((is_numeric($relacion) && $relacion > 0 && is_numeric($cantidad) && $cantidad > 0) || is_numeric($valorActividad) && $valorActividad > 0) {
                                            // Mano de obra
                                            if ($tipo == "M") {
                                                // Existe el registro
                                                if (isset($recActManoObraExistente[$centroCosto][$actividad][$manoObraExistente[$mobSum]])) {
                                                    $auxRecActMob = $recActManoObraExistente[$centroCosto][$actividad][$manoObraExistente[$mobSum]];

                                                    // Actualizar si es diferente
                                                    if ($auxRecActMob->ram_unidad_consumo != $unidadConsumo || $auxRecActMob->ram_relacion != $relacion ||
                                                        $auxRecActMob->ram_consumo_actividad != $cantidad || $auxRecActMob->ram_valor_actividad != $valorActividad) {
                                                        RecActividadManoObra::on('costos_principal')
                                                                            ->where('con_fk_id', $con_fk_id)
                                                                            ->where('ins_fk_id', $ins_fk_id)
                                                                            ->where('ram_ano', $rda_ano)
                                                                            ->where('cco_fk_id', $centrosCostoExistentes[$centroCosto])
                                                                            ->where('act_fk_id', $actividadesExistentes[$actividad])
                                                                            ->where('mob_fk_id', $manoObraExistente[$mobSum])
                                                        ->update(
                                                            [
                                                                "ram_unidad_consumo" => $unidadConsumo,
                                                                "ram_relacion" => $relacion !== "" ? $relacion : null,
                                                                "ram_factor_conversion" => $relacion !== "" ? 1 / $relacion : null,
                                                                "ram_consumo_actividad" => $cantidad !== "" ? $cantidad : null,
                                                                "ram_valor_actividad" => $valorActividad !== "" ? $valorActividad : null
                                                            ]
                                                        );
                                                    }
                                                } else { // Es necesario crearlo
                                                    $mob_pk_id = $manoObraExistente[$mobSum];

                                                    RecActividadManoObra::on('costos_principal')->create(
                                                        [
                                                            "con_fk_id" => $con_fk_id,
                                                            "ins_fk_id" => $ins_fk_id,
                                                            "ram_ano" => $rda_ano,
                                                            "cco_fk_id" => $centrosCostoExistentes[$centroCosto],
                                                            "act_fk_id" => $actividadesExistentes[$actividad],
                                                            "mob_fk_id" => $mob_pk_id,
                                                            "ram_unidad_medida" => "Minutos",
                                                            "ram_unidad_consumo" => $unidadConsumo,
                                                            "ram_relacion" => $relacion !== "" ? $relacion : null,
                                                            "ram_factor_conversion" => $relacion !== "" ? 1 / $relacion : null,
                                                            "ram_consumo_actividad" => $cantidad !== "" ? $cantidad : null,
                                                            "ram_valor_actividad" => $valorActividad !== "" ? $valorActividad : null
                                                        ]
                                                    );

                                                    $recActManoObraExistente[$centroCosto][$actividad][$mob_pk_id] = new \stdClass();

                                                    $recActManoObraExistente[$centroCosto][$actividad][$mob_pk_id]->ram_unidad_consumo = $unidadConsumo;
                                                    $recActManoObraExistente[$centroCosto][$actividad][$mob_pk_id]->ram_relacion = $relacion;
                                                    $recActManoObraExistente[$centroCosto][$actividad][$mob_pk_id]->ram_consumo_actividad = $cantidad;
                                                    $recActManoObraExistente[$centroCosto][$actividad][$mob_pk_id]->ram_valor_actividad = $valorActividad;
                                                }
                                            } else { // Suministros
                                                // Existe el registro
                                                if (isset($recActSuministrosExistente[$centroCosto][$actividad][$suministrosExistentes[$mobSum]->sum_pk_id])) {
                                                    $auxRecActSum = $recActSuministrosExistente[$centroCosto][$actividad][$suministrosExistentes[$mobSum]->sum_pk_id];

                                                    // Actualizar si es diferente
                                                    if ($auxRecActSum->ras_unidad_consumo != $unidadConsumo || $auxRecActSum->ras_relacion != $relacion ||
                                                        $auxRecActSum->ras_consumo_actividad != $cantidad) {
                                                        RecActividadSuministros::on('costos_principal')
                                                                               ->where('con_fk_id', $con_fk_id)
                                                                               ->where('ins_fk_id', $ins_fk_id)
                                                                               ->where('ras_ano', $rda_ano)
                                                                               ->where('cco_fk_id', $centrosCostoExistentes[$centroCosto])
                                                                               ->where('act_fk_id', $actividadesExistentes[$actividad])
                                                                               ->where('sum_fk_id', $suministrosExistentes[$mobSum]->sum_pk_id)
                                                        ->update(
                                                            [
                                                                "ras_unidad_consumo" => $unidadConsumo,
                                                                "ras_relacion" => $relacion,
                                                                "ras_factor_conversion" => 1 / $relacion,
                                                                "ras_consumo_actividad" => $cantidad
                                                            ]
                                                        );
                                                    }
                                                } else { // Es necesario crearlo
                                                    $sum_pk_id = $suministrosExistentes[$mobSum]->sum_pk_id;

                                                    RecActividadSuministros::on('costos_principal')->create(
                                                        [
                                                            "con_fk_id" => $con_fk_id,
                                                            "ins_fk_id" => $ins_fk_id,
                                                            "ras_ano" => $rda_ano,
                                                            "cco_fk_id" => $centrosCostoExistentes[$centroCosto],
                                                            "act_fk_id" => $actividadesExistentes[$actividad],
                                                            "sum_fk_id" => $sum_pk_id,
                                                            "ras_unidad_medida" => $suministrosExistentes[$mobSum]->sum_unidad_medida,
                                                            "ras_unidad_consumo" => $unidadConsumo,
                                                            "ras_relacion" => $relacion,
                                                            "ras_factor_conversion" => 1 / $relacion,
                                                            "ras_consumo_actividad" => $cantidad
                                                        ]
                                                    );

                                                    $recActSuministrosExistente[$centroCosto][$actividad][$sum_pk_id] = new \stdClass();

                                                    $recActSuministrosExistente[$centroCosto][$actividad][$sum_pk_id]->ras_unidad_consumo = $unidadConsumo;
                                                    $recActSuministrosExistente[$centroCosto][$actividad][$sum_pk_id]->ras_relacion = $relacion;
                                                    $recActSuministrosExistente[$centroCosto][$actividad][$sum_pk_id]->ras_consumo_actividad = $cantidad;
                                                }
                                            }
                                        } else {
                                            $valoresIncorrectos = true;
                                        }
                                    } else {
                                        if ($tipo == "M") {
                                            $manoObraInexistente .= $mobSum.", ";
                                        } else {
                                            $suministrosInexistentes .= $mobSum.", ";
                                        }
                                    }
                                } else {
                                    $tiposInexistentes = true;
                                }
                            } else {
                                $actCentrosCostoInexistentes .= $centroCosto." - ".$actividad.", ";
                            }
                        } else {
                            $descripcionLargas = true;
                        }
                    } else {
                        $camposVacios = true;
                    }

                    $registrosProcesados++;
                }

                // Campos vacios
                if ($camposVacios) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay campos vacíos.";
                }

                // Valores numericos incorrectos
                if ($valoresIncorrectos) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay valores numéricos incorrectos (los decimales deben ser separados con un punto).";
                }

                // Descripciones largas
                if ($descripcionLargas) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "El máximo de caracteres para la unidad de consumo es de 80 caracteres.";
                }

                // Tipos inexistentes
                if ($tiposInexistentes) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "El tipo debe ser 'M' (mano de obra) o 'S' (suministros).";
                }

                // Errores de relacion centros de costo - actividad
                if ($actCentrosCostoInexistentes !== "") {
                    $actCentrosCostoInexistentes[strlen($actCentrosCostoInexistentes) - 1] = " ";
                    $actCentrosCostoInexistentes[strlen($actCentrosCostoInexistentes) - 2] = " ";
                    $actCentrosCostoInexistentes = "No existen las siguientes relaciones entre centro de costo y actividad: ".$actCentrosCostoInexistentes;

                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores = $actCentrosCostoInexistentes;
                }

                // Mano de obra inexistente
                if ($manoObraInexistente !== "") {
                    $manoObraInexistente[strlen($manoObraInexistente) - 1] = " ";
                    $manoObraInexistente[strlen($manoObraInexistente) - 2] = " ";
                    $manoObraInexistente = "No existe la siguiente mano de obra: ".$manoObraInexistente;

                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores = $manoObraInexistente;
                }

                // Suministros inexistentes
                if ($suministrosInexistentes !== "") {
                    $suministrosInexistentes[strlen($suministrosInexistentes) - 1] = " ";
                    $suministrosInexistentes[strlen($suministrosInexistentes) - 2] = " ";
                    $suministrosInexistentes = "No existen los siguientes suministros: ".$suministrosInexistentes;

                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores = $suministrosInexistentes;
                }

                if (!$camposVacios && !$descripcionLargas && !$tiposInexistentes && $actCentrosCostoInexistentes == "" && $manoObraInexistente == "" &&
                    $suministrosInexistentes == "") {
                    $resultados->correcto = true;
                } else {
                    $resultados->correcto = false;
                }

                $resultados->registros = $registrosProcesados;
            }
        });

        return json_encode($resultados);
    }

    private function buscarDuplicadosCargaaCsv($archivo) {
        $relExistentes = [];
        $suministrosDuplicados = "";
        $cargosDuplicados = "";

        foreach ($archivo as $relacion) {
            $cco = $relacion[0];
            $act = $relacion[1];
            $tipo = $relacion[2];
            $mobSum = $relacion[3];

            if (isset($relExistentes[$cco][$act][$tipo][$mobSum])) {
                $relExistentes[$cco][$act][$tipo][$mobSum]++;

                if ($relExistentes[$cco][$act][$tipo][$mobSum] == 1) {
                    if ($tipo == "S") {
                        if ($suministrosDuplicados != "") {
                            $suministrosDuplicados .= ", ";
                        } else {
                            $suministrosDuplicados .= "Los siguientes suministros están duplicados: ";
                        }

                        $suministrosDuplicados .= "Suministro ".$mobSum." en relación ".$cco." - ".$act;
                    } else if ($tipo == "M") {
                        if ($cargosDuplicados != "") {
                            $cargosDuplicados .= ", ";
                        } else {
                            $cargosDuplicados .= "Los siguientes cargos están duplicados: ";
                        }

                        $cargosDuplicados .= "Cargo ".$mobSum." en relación ".$cco." - ".$act;
                    }
                }
            } else {
                $relExistentes[$cco][$act][$tipo][$mobSum] = 0;
            }
        }

        return array("sum" => $suministrosDuplicados,
                     "mob" => $cargosDuplicados);
    }

    public function validarAvanceCentrosCosto(Request $request) {
        return \DB::select("select acc.cco_fk_id,
                                   count(*) filter (where mob.mob is null and sum.sum is null) as conteo
                            from costos_principal.actividades_centro_costo as acc
                            left join (
                                select distinct cco_fk_id, act_fk_id, count(*) as mob
                                from costos_principal.rec_actividad_mano_obra
                                where con_fk_id = ".$request->input('con_fk_id')." and
                                      ins_fk_id = '".$request->input('ins_fk_id')."' and
                                      ram_ano = ".$request->input('rda_ano')."
                                group by 1,2
                            ) as mob on (acc.cco_fk_id = mob.cco_fk_id and acc.act_fk_id = mob.act_fk_id)
                            left join (
                                select distinct cco_fk_id, act_fk_id, count(*) as sum
                                from costos_principal.rec_actividad_suministros
                                where con_fk_id = ".$request->input('con_fk_id')." and
                                      ins_fk_id = '".$request->input('ins_fk_id')."' and
                                      ras_ano = ".$request->input('rda_ano')."
                                group by 1,2
                            ) as sum on (acc.cco_fk_id = sum.cco_fk_id and acc.act_fk_id = sum.act_fk_id)
                            where con_fk_id = ".$request->input('con_fk_id')." and
                                  ins_fk_id = '".$request->input('ins_fk_id')."' and
                                  acc_ano = ".$request->input('rda_ano')."
                            group by 1
                            order by 1");
    }
}
