<?php

namespace App\Http\Controllers;

use App\Models\DetalleElementos;
use App\Models\TipoRecurso;
use App\Models\CaracterRecurso;
use App\Models\CuentasContables;
use App\Models\AvanceModulos;
use App\Models\Parametros;
use Illuminate\Http\Request;

class CuentasContablesController extends Controller
{
    private $apiKey;

    function __construct() {
        $apiController = new ApiController();

        $this->apiKey = $apiController->getApiKey()["key"];
    }

    public function crearCuentaContable(Request $request) {
        $cuentaContable = CuentasContables::on('costos_principal');

        $id = $cuentaContable->create(
            [
                "con_fk_id" => $request->input("con_fk_id"),
                "ins_fk_id" => $request->input("ins_fk_id"),
                "cuc_ano" => $request->input("cuc_ano"),
                "cuc_cuenta" => $request->input("cuc_cuenta"),
                "cuc_descripcion" => $request->input("cuc_descripcion"),
                "nac_fk_id" => $request->input("nac_fk_id"),
                "elm_fk_id" => $request->input("elm_fk_id"),
                "del_fk_id" => $request->input("del_fk_id"),
                "tre_fk_id" => $request->input("tre_fk_id"),
                "cre_fk_id" => $request->input("cre_fk_id")
            ]
        );

        return array("response" => $id->cuc_pk_id);
    }

    public function actualizarCuentaContable(Request $request) {
        CuentasContables::on('costos_principal')
                        ->where("con_fk_id", $request->input("con_fk_id"))
                        ->where("ins_fk_id", $request->input("ins_fk_id"))
                        ->where("cuc_ano", $request->input("cuc_ano"))
                        ->where("cuc_cuenta", $request->input("cuc_cuenta"))
        ->update(
            [
                "cuc_descripcion" => $request->input("cuc_descripcion"),
                "nac_fk_id" => $request->input("nac_fk_id"),
                "elm_fk_id" => $request->input("elm_fk_id"),
                "del_fk_id" => $request->input("del_fk_id"),
                "tre_fk_id" => $request->input("tre_fk_id"),
                "cre_fk_id" => $request->input("cre_fk_id")
            ]
        );
    }

    public function actualizacionMasivaCuentasContables(Request $request) {
        $cuentas = json_decode($request->input('cuentas'));

        foreach($cuentas as $cuenta) {
            CuentasContables::on('costos_principal')
                            ->where("con_fk_id", $request->input("con_fk_id"))
                            ->where("ins_fk_id", $request->input("ins_fk_id"))
                            ->where("cuc_ano", $request->input("cuc_ano"))
                            ->where("cuc_cuenta", $cuenta)
            ->update(
                [
                    "elm_fk_id" => $request->input("elm_fk_id"),
                    "del_fk_id" => $request->input("del_fk_id"),
                    "tre_fk_id" => $request->input("tre_fk_id"),
                    "cre_fk_id" => $request->input("cre_fk_id")
                ]
            );
        }
    }

    public function borrarCuentaContable(Request $request) {
        CuentasContables::on('costos_principal')
                        ->where("cuc_pk_id", $request->input("cuc_pk_id"))
                        ->delete();
    }

    public function getCuentasContables(Request $request) {
        return CuentasContables::on('costos_principal')
                               ->selectRaw('cuc_pk_id, cuentas_contables.con_fk_id as con_fk_id,
                                            cuentas_contables.ins_fk_id as ins_fk_id, cuc_ano,
                                            cuc_cuenta, cuc_descripcion, cuentas_contables.nac_fk_id as nac_fk_id,
                                            nac_descripcion, cuentas_contables.elm_fk_id as elm_fk_id,
                                            elm_descripcion, cuentas_contables.del_fk_id as del_fk_id,
                                            del_descripcion, cuentas_contables.tre_fk_id as tre_fk_id,
                                            tre_descripcion, cuentas_contables.cre_fk_id as cre_fk_id, cre_descripcion')
                               ->leftJoin('naturaleza_cuenta', 'nac_pk_id', '=', 'nac_fk_id')
                               ->leftJoin('elementos', 'elm_pk_id', '=', 'elm_fk_id')
                               ->leftJoin('detalle_elementos', 'del_pk_id', '=', 'del_fk_id')
                               ->leftJoin('tipo_recurso', 'tre_pk_id', '=', 'tre_fk_id')
                               ->leftJoin('caracter_recurso', 'cre_pk_id', '=', 'cre_fk_id')
                               ->where('cuentas_contables.con_fk_id', $request->input('con_fk_id'))
                               ->where('cuentas_contables.ins_fk_id', $request->input('ins_fk_id'))
                               ->where('cuc_ano', $request->input('cuc_ano'))
                               ->orderBy('cuc_cuenta')
                               ->orderBy('cuc_descripcion')
                               ->get()->toArray();

    }

    public function getCuentaContableEspecifica(Request $request) {
        return CuentasContables::on('costos_principal')
                               ->where('con_fk_id', $request->input('con_fk_id'))
                               ->where('ins_fk_id', $request->input('ins_fk_id'))
                               ->where('cuc_ano', $request->input('cuc_ano'))
                               ->where('cuc_cuenta', $request->input('cuc_cuenta'))
                               ->get()->toArray();
    }

    public function cargarArchivoCuentasContables(Request $request) {
        $apiKey = $request->apiKey;

        if ($apiKey === $this->apiKey) {
            $rutaDelArchivo = $request->cuentasContables->path();
            $delimitador = $request->delimitador;
            $archivo = fopen($rutaDelArchivo, 'r');
            $cuentasContables = array();
            $primeraLinea = true;

            // Extraer cada línea del archivo CSV y convertirlo en un arreglo
            while($linea = fgetcsv($archivo, 1000, $delimitador)) {
                if (!$primeraLinea) {
                    $registro = $linea;
                    array_push($cuentasContables, $registro);
                } else {
                    $primeraLinea = false;
                }
            }

            fclose($archivo);

            return $this->procesarArchivoCuentasContables($cuentasContables,
                                                          $request->con_fk_id,
                                                          $request->ins_fk_id,
                                                          $request->cuc_ano);
        } else {
            throw new \Exception('Imposible completar la petición.');
        }
    }

    private function procesarArchivoCuentasContables($cuentasContables, $con_fk_id, $ins_fk_id, $cuc_ano) {
        $resultados = new \stdClass();
        $resultados->errores = "";

        \DB::transaction(function() use(&$resultados, $cuentasContables, $con_fk_id, $ins_fk_id, $cuc_ano) {
            if (count($cuentasContables) === 0) {
                $resultados->correcto = false;
                $resultados->errores = 'El archivo está vacío. ';
                return json_encode($resultados);
            } else if (count($cuentasContables[0]) !== 6) {
                $resultados->correcto = false;
                $resultados->errores = 'La cantidad de columnas no corresponde. ';
                return json_encode($resultados);
            } else {
                $cuentasContablesBd = CuentasContables::on('costos_principal')
                                                    ->where('con_fk_id', $con_fk_id)
                                                    ->where('ins_fk_id', $ins_fk_id)
                                                    ->where('cuc_ano', $cuc_ano)
                                                    ->get()->toArray();

                $detalleElementosBd = DetalleElementos::on('costos_principal')
                                                    ->where('con_fk_id', $con_fk_id)
                                                    ->where('ins_fk_id', $ins_fk_id)
                                                    ->where('del_ano', $cuc_ano)
                                                    ->get()->toArray();

                $tipoRecursoBd = TipoRecurso::on('costos_principal')->get()->toArray();
                $caracterRecursoBd = CaracterRecurso::on('costos_principal')->get()->toArray();

                $cuentasContablesExistentes = [];
                $detalleElementosExistentes = [];
                $tipoRecursoExistentes = [];
                $caracterRecursoExistentes = [];
                $registrosProcesados = 0;

                // Crear las relaciones existentes en la base de datos
                foreach ($cuentasContablesBd as $cutDb) {
                    $cuentasContablesExistentes[$cutDb['cuc_cuenta']] = new \stdClass();
                    
                    $cuentasContablesExistentes[$cutDb['cuc_cuenta']]->cuc_descripcion = $cutDb['cuc_descripcion'];
                    $cuentasContablesExistentes[$cutDb['cuc_cuenta']]->nac_fk_id = $cutDb['nac_fk_id'];
                    $cuentasContablesExistentes[$cutDb['cuc_cuenta']]->del_fk_id = $cutDb['del_fk_id'];
                    $cuentasContablesExistentes[$cutDb['cuc_cuenta']]->tre_fk_id = $cutDb['tre_fk_id'];
                    $cuentasContablesExistentes[$cutDb['cuc_cuenta']]->cre_fk_id = $cutDb['cre_fk_id'];
                }

                foreach ($detalleElementosBd as $delDb) {
                    $detalleElementosExistentes[$delDb['del_pk_id']] = $delDb['elm_fk_id'];
                }

                foreach ($tipoRecursoBd as $treDb) {
                    $tipoRecursoExistentes[$treDb['tre_pk_id']] = $treDb['tre_descripcion'];
                }

                foreach ($caracterRecursoBd as $creDb) {
                    $caracterRecursoExistentes[$creDb['cre_pk_id']] = $creDb['cre_descripcion'];
                }

                // Errores de los centros de utilidad
                $codCuentaErroneo = "";
                $descripcionLargas = false;
                $natIncorrecta = false;
                $detalleElementoIncorrecto = false;
                $tipoRecursoIncorrecto = false;
                $caracterRecursoIncorrecto = false;

                // Revisar el archivo respecto a las relaciones existentes
                foreach($cuentasContables as $cucCsv) {
                    $cuenta = $cucCsv[0];
                    $descripcion = utf8_encode($cucCsv[1]);
                    $naturaleza = "";
                    $detalleElemento = trim($cucCsv[3]) == "" ? null : trim($cucCsv[3]);
                    $tipoRecurso = trim($cucCsv[4]) == "" ? null : trim($cucCsv[4]);
                    $caracterRecurso = trim($cucCsv[5]) == "" ? null : trim($cucCsv[5]);

                    if (strtoupper(trim($cucCsv[2])) == "D") {
                        $naturaleza = 1;
                    } else if (strtoupper(trim($cucCsv[2])) == "C") {
                        $naturaleza = 2;
                    } else {
                        $naturaleza = 0;
                    }

                    // Naturaleza correcta
                    if ($naturaleza != 0) {
                        if (isset($detalleElementosExistentes[$detalleElemento]) || $detalleElemento == "") { 
                            if (isset($tipoRecursoExistentes[$tipoRecurso]) || $tipoRecurso == "") {
                                if (isset($caracterRecursoExistentes[$caracterRecurso]) || $caracterRecurso == "") {
                                    // Existe la cuenta contable
                                    if (isset($cuentasContablesExistentes[$cuenta])) {
                                        // Actualizar si el nombre el diferente
                                        if ($cuentasContablesExistentes[$cuenta]->cuc_descripcion != $descripcion ||
                                            $cuentasContablesExistentes[$cuenta]->nac_fk_id != $naturaleza ||
                                            $cuentasContablesExistentes[$cuenta]->del_fk_id != $detalleElemento ||
                                            $cuentasContablesExistentes[$cuenta]->tre_fk_id != $tipoRecurso ||
                                            $cuentasContablesExistentes[$cuenta]->cre_fk_id != $caracterRecurso) {
                                            // Descripcion largas
                                            if (strlen($descripcion) <= 80) {
                                                $elementoAux = null;

                                                if ($detalleElemento != "") {
                                                    $elementoAux = $detalleElementosExistentes[$detalleElemento];
                                                }

                                                CuentasContables::on('costos_principal')
                                                                ->where("con_fk_id", $con_fk_id)
                                                                ->where("ins_fk_id", $ins_fk_id)
                                                                ->where("cuc_ano", $cuc_ano)
                                                                ->where("cuc_cuenta", $cuenta)
                                                ->update(
                                                    [
                                                        "cuc_descripcion" => $descripcion,
                                                        "nac_fk_id" => $naturaleza,
                                                        "elm_fk_id" => $elementoAux,
                                                        "del_fk_id" => $detalleElemento,
                                                        "tre_fk_id" => $tipoRecurso,
                                                        "cre_fk_id" => $caracterRecurso
                                                    ]
                                                );

                                                $registrosProcesados++;
                                            } else {
                                                $descripcionLargas = true;
                                            }
                                        } else {
                                            $registrosProcesados++;
                                        }
                                    } else { // No existe, es necesario crearla
                                        // Validar la longitud de la cuenta
                                        if (strlen($cuenta) <= 15) {
                                            // Validar la longitud de la descripcion
                                            if (strlen($descripcion) <= 80) {
                                                $cuentaContable = CuentasContables::on('costos_principal');

                                                $elementoAux = null;

                                                if ($detalleElemento != "") {
                                                    $elementoAux = $detalleElementosExistentes[$detalleElemento];
                                                }

                                                $id = $cuentaContable->create(
                                                    [
                                                        "con_fk_id" => $con_fk_id,
                                                        "ins_fk_id" => $ins_fk_id,
                                                        "cuc_ano" => $cuc_ano,
                                                        "cuc_cuenta" => $cuenta,
                                                        "cuc_descripcion" => $descripcion,
                                                        "nac_fk_id" => $naturaleza,
                                                        "elm_fk_id" => $elementoAux,
                                                        "del_fk_id" => $detalleElemento,
                                                        "tre_fk_id" => $elementoAux === 2 ? 2 : $tipoRecurso,
                                                        "cre_fk_id" => $caracterRecurso
                                                    ]
                                                );

                                                $registrosProcesados++;

                                                $cuentasContablesExistentes[$cuenta] = new \stdClass();

                                                $cuentasContablesExistentes[$cuenta]->cuc_descripcion = $descripcion;
                                                $cuentasContablesExistentes[$cuenta]->nac_fk_id = $naturaleza;
						$cuentasContablesExistentes[$cuenta]->elm_fk_id = $elementoAux;
						$cuentasContablesExistentes[$cuenta]->del_fk_id = $detalleElemento;
						$cuentasContablesExistentes[$cuenta]->tre_fk_id = $elementoAux === 2 ? 2 : $tipoRecurso;
						$cuentasContablesExistentes[$cuenta]->cre_fk_id = $caracterRecurso;
                                            } else {
                                                $descripcionLargas = true;
                                            }
                                        } else {
                                            $codCuentaErroneo .= $cuenta.", ";
                                        }
                                    }
                                } else {
                                    $caracterRecursoIncorrecto = true;
                                }
                            } else {
                                $tipoRecursoIncorrecto = true;
                            }
                        } else {
                            $detalleElementoIncorrecto = true;
                        }
                    } else {
                        $natIncorrecta = true;
                    }
                }

                // Errores de subcentros de utilidad
                if ($codCuentaErroneo !== "") {
                    $codCuentaErroneo[strlen($codCuentaErroneo) - 1] = " ";
                    $codCuentaErroneo[strlen($codCuentaErroneo) - 2] = " ";
                    $codCuentaErroneo = "Los siguientes códigos de la cuenta tienen más de 15 caracteres: ".$codCuentaErroneo;

                    $resultados->errores = $codCuentaErroneo;
                }

                // Descripciones largas
                if ($descripcionLargas) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay descripciones de cuenta con más de 80 caracteres";
                }

                // Naturalezas incorrectas
                if ($natIncorrecta) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay naturalezas incorrectas. Deben ser 'D' o 'C'";
                }

                // Detalle elementos incorrectos
                if ($detalleElementoIncorrecto) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay códigos de detalles de elementos inexistentes.";
                }

                // Tipo de recurso incorrectos
                if ($tipoRecursoIncorrecto) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay códigos de tipos de recurso inexistentes.";
                }

                // Caracter de recurso incorrectos
                if ($caracterRecursoIncorrecto) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay códigos de caracter de recurso inexistentes.";
                }

                if (!$descripcionLargas && $codCuentaErroneo === "" && !$natIncorrecta && !$detalleElementoIncorrecto &&
                    !$tipoRecursoIncorrecto && !$caracterRecursoIncorrecto) {
                    $resultados->correcto = true;
                } else {
                    $resultados->correcto = false;
                }

                $resultados->registros = $registrosProcesados;
            }
        });

        return json_encode($resultados);
    }

    public function importarCuentasContables(Request $request) {
        \DB::transaction(function() use($request) {
            $anoActual = $request->input('anoActual');
            $anoImportacion = $request->input('anoImportacion');

            DetalleElementos::on('costos_principal')
                            ->where('con_fk_id', $request->input('con_fk_id'))
                            ->where('ins_fk_id', $request->input('ins_fk_id'))
                            ->where('del_ano', $anoActual)
                            ->delete();

            CuentasContables::on('costos_principal')
                            ->where('con_fk_id', $request->input('con_fk_id'))
                            ->where('ins_fk_id', $request->input('ins_fk_id'))
                            ->where('cuc_ano', $anoActual)
                            ->delete();

            // Detalle de elementos
            \DB::select("insert into costos_principal.detalle_elementos (con_fk_id, ins_fk_id, del_ano, elm_fk_id, del_descripcion)
                         select ".$request->input('con_fk_id').",
                                '".$request->input('ins_fk_id')."',
                                ".$anoActual.",
                                elm_fk_id,
                                del_descripcion
                         from costos_principal.detalle_elementos
                         where con_fk_id = ".$request->input('con_fk_id')." and
                               ins_fk_id = '".$request->input('ins_fk_id')."' and
                               del_ano = ".$anoImportacion);

            $detalleElementosBd = DetalleElementos::on('costos_principal')
                                                  ->where('con_fk_id', $request->input('con_fk_id'))
                                                  ->where('ins_fk_id', $request->input('ins_fk_id'))
                                                  ->where('del_ano', $anoActual)
                                                  ->get()->toArray();

            $detalleElementosExistentes = [];

            foreach($detalleElementosBd as $del) {
                $detalleElementosExistentes[$del['del_descripcion']] = $del['del_pk_id'];
            }

            // Cuentas contables
            $cuentasContables = \DB::select("select cuc_cuenta,
                                                    cuc_descripcion,
                                                    nac_fk_id,
                                                    cuc.elm_fk_id,
                                                    del_descripcion,
                                                    tre_fk_id,
                                                    cre_fk_id
                                            from costos_principal.cuentas_contables as cuc
                                            left join costos_principal.detalle_elementos as del on (cuc.del_fk_id = del.del_pk_id) 
                                            where cuc.con_fk_id = ".$request->input('con_fk_id')." and
                                                  cuc.ins_fk_id = '".$request->input('ins_fk_id')."' and
                                                  cuc_ano = ".$anoImportacion);

            foreach($cuentasContables as $cuc) {
                CuentasContables::on('costos_principal')->create(
                    [
                        "con_fk_id" => $request->input('con_fk_id'),
                        "ins_fk_id" => $request->input('ins_fk_id'),
                        "cuc_ano" => $anoActual,
                        "cuc_cuenta" => $cuc->cuc_cuenta,
                        "cuc_descripcion" => $cuc->cuc_descripcion,
                        "nac_fk_id" => $cuc->nac_fk_id,
                        "elm_fk_id" => $cuc->elm_fk_id,
                        "del_fk_id" => $cuc->del_descripcion != null ? $detalleElementosExistentes[$cuc->del_descripcion] : null,
                        "tre_fk_id" => $cuc->tre_fk_id,
                        "cre_fk_id" => $cuc->cre_fk_id
                    ]
                );
            }

            $avance = AvanceModulos::on('costos_principal')
                                   ->where('con_fk_id', $request->input('con_fk_id'))
                                   ->where('ins_fk_id', $request->input('ins_fk_id'))
                                   ->where('avm_ano', $anoActual)
                                   ->where('avm_mes', null);

            if ($avance->count() > 0) {
                $avance->update(
                    [
                        "avm_det_elementos" => count($detalleElementosBd) > 0 ? true : false
                    ]
                );
            } else {
                AvanceModulos::on('costos_principal')
                ->create(
                    [
                        "con_fk_id" => $request->input('con_fk_id'),
                        "ins_fk_id" => $request->input('ins_fk_id'),
                        "avm_ano" => $anoActual,
                        "avm_mes" => null,
                        "avm_det_elementos" => count($detalleElementosBd) > 0 ? true : false
                    ]
                );
            }
        });
    }

    private function verificarAvance($contrato, $institucion, $ano) {
        // Verificar si existe registro del avance
        $conteo = AvanceModulos::on('costos_principal')
                               ->where('con_fk_id', $contrato)
                               ->where('ins_fk_id', $institucion)
                               ->where('avm_ano', $ano)
                               ->whereNull('avm_mes')
                               ->count();

        // Verificar el avance del modulo
        $cuc = CuentasContables::on('costos_principal')
                               ->where('con_fk_id', $contrato)
                               ->where('ins_fk_id', $institucion)
                               ->where('cuc_ano', $ano)
                               ->count();

        $cuc2 = CuentasContables::on('costos_principal')
                               ->where('con_fk_id', $contrato)
                               ->where('ins_fk_id', $institucion)
                               ->where('cuc_ano', $ano)
                               ->whereNull('elm_fk_id')
                               ->whereNull('del_fk_id')
                               ->whereNull('tre_fk_id')
                               ->whereNull('cre_fk_id')
                               ->count();

        if ($conteo > 0) {
            if ($cuc > 0 && $cuc2 == 0) {
                AvanceModulos::on('costos_principal')
                                ->where('con_fk_id', $contrato)
                                ->where('ins_fk_id', $institucion)
                                ->where('avm_ano', $ano)
                                ->where('avm_mes', null)
                ->update(
                    [
                        "avm_cuentas" => true
                    ]
                );
            } else {
                AvanceModulos::on('costos_principal')
                            ->where('con_fk_id', $contrato)
                            ->where('ins_fk_id', $institucion)
                            ->where('avm_ano', $ano)
                            ->where('avm_mes', null)
                ->update(
                    [
                        "avm_cuentas" => false
                    ]
                ); 
            }
        } else {
            if ($cuc > 0 && $cuc2 == 0) {
                AvanceModulos::on('costos_principal')
                ->create(
                    [
                        "con_fk_id" => $contrato,
                        "ins_fk_id" => $institucion,
                        "avm_ano" => $ano,
                        "avm_mes" => null,
                        "avm_det_elementos" => true
                    ]
                );
            } else {
                AvanceModulos::on('costos_principal')
                ->create(
                    [
                        "con_fk_id" => $contrato,
                        "ins_fk_id" => $institucion,
                        "avm_ano" => $ano,
                        "avm_mes" => null,
                        "avm_det_elementos" => false
                    ]
                );
            }
        }          
    }
}
