<?php

namespace App\Http\Controllers;

use App\Models\CostoPaquetes;
use Illuminate\Http\Request;

class CostoPaquetesController extends Controller
{
    public function getCostoPaquetes(Request $request) {
        return CostoPaquetes::on('costos_principal')
                            ->selectRaw('cpq_paquete,
                                         paq.act_codigo as paq_codigo,
                                         paq.act_descripcion as paq_descripcion,
                                         cco_cod_homologado,
                                         cco_descripcion,
                                         act.act_codigo,
                                         act.act_descripcion,
                                         sum.sum_codigo,
                                         sum.sum_nombre,
                                         paa.paq_frec_realizacion as paa_frec_realizacion,
                                         paa.paq_cantidad as paa_cantidad,
                                         pas.paq_frec_realizacion as pas_frec_realizacion,
                                         pas.paq_cantidad as pas_cantidad,
                                         cpq_costo')
                            ->join('actividades as paq', 'paq.act_pk_id', 'cpq_paquete')
                            ->join('centros_costo', 'cco_pk_id', 'cco_fk_id')
                            ->leftJoin('actividades as act', 'act.act_pk_id', 'act_fk_id')
                            ->leftJoin('suministros as sum', 'sum.sum_pk_id', 'sum_fk_id')
                            ->leftJoin('paquetes_actividades as paa', function($join) {
                                $join->on('paa.paq_paquete', 'cpq_paquete');
                                $join->on('paa.paq_actividad', 'act.act_pk_id');
                            })
                            ->leftJoin('paquetes_actividades as pas', function($join) {
                                $join->on('pas.paq_paquete', 'cpq_paquete');
                                $join->on('pas.paq_suministro', 'sum.sum_pk_id');
                            })
                            ->where('costo_paquetes.con_fk_id', $request->input('con_fk_id'))
                            ->where('costo_paquetes.ins_fk_id', $request->input('ins_fk_id'))
                            ->where('cpq_ano', $request->input('cpq_ano'))
                            ->where('cpq_mes', $request->input('cpq_mes'))
                            ->orderBy('cpq_paquete')
                            ->orderBy('act_descripcion')
                            ->orderBy('cpq_costo')
                            ->get()->toArray();
    }
}
