<?php

namespace App\Http\Controllers;

use App\Models\Administradores;

use Illuminate\Support\Str;
use Illuminate\Http\Request;

class AdministradoresController extends Controller
{
    function __construct() {}

    public function validarUsuario(Request $request) {
        $usuario = $request->input("usuario");
        $contrasena = $request->input("contrasena");

        $usuarioDB = Administradores::on('costos_principal')
                                    ->select('adm_pk_id', 'adm_contrasena')
                                    ->where('adm_cuenta', $usuario);

        // Validar si el usuario existe
        if ($usuarioDB->count() && \Crypt::decryptString($usuarioDB->value("adm_contrasena")) == $contrasena) {
            // Crear la llave de inicio de sesion
            $llave = Str::random(22).date("d").date("m").date("Y");

            $id = $usuarioDB->value("adm_pk_id");

            // Actualizar la llave en el servidor
            $usuarioDB->update(array('adm_llave' => \Crypt::encryptString($llave)));

            $usuarioDBAux = Administradores::on('costos_principal')
                                           ->select('adm_pk_id', 'adm_cuenta', 'adm_nombre', 'adm_correo_elec')
                                           ->where('adm_pk_id', $id)
                                           ->get()->toArray()[0];

            // Enviar la llave al usuario
            return json_encode(array("token" => $llave,
                                     "id_usuario" => $usuarioDBAux["adm_pk_id"],
                                     "cuenta_usuario" => $usuarioDBAux["adm_cuenta"],
                                     "nombre_usuario" => $usuarioDBAux['adm_nombre'],
                                     "correo_usuario" => $usuarioDBAux['adm_correo_elec']));
        }
        else {
            return json_encode(array("token" => 0));
        }
    }

    public function validarTokenUsuario(Request $request) {
        $usuario = $request->input("usuario");
        $token = $request->input("token");

        $usuarioDB = Administradores::on('costos_principal')
                                    ->select('adm_llave')->where('adm_cuenta', $usuario)->get()->toArray();

        if (count($usuarioDB) > 0) {
            if(\Crypt::decryptString($usuarioDB[0]['adm_llave']) == $token)
                return json_encode(array("response" => 1));
            else
                return json_encode(array("response" => 0));
        }
        else {
            return json_encode(array("response" => 0));
        }
    }
}